/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib;

import io.redlink.solrlib.SolrCoreDescriptor;
import io.redlink.utils.ResourceLoaderUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCoreDescriptor
implements SolrCoreDescriptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String coreName;
    private final Path coreBundle;
    private int numShards;
    private int replicationFactor;

    public SimpleCoreDescriptor(String coreName, Path coreBundle) {
        this.coreName = coreName;
        this.coreBundle = coreBundle;
        this.numShards = 1;
        this.replicationFactor = 1;
    }

    @Override
    public String getCoreName() {
        return this.coreName;
    }

    @Override
    public void initCoreDirectory(Path coreDir, Path sharedLibDir) throws IOException {
        this.log.debug("{}: initializing core-dir {}", (Object)this.coreName, (Object)coreDir);
        if (Files.isDirectory(this.coreBundle, new LinkOption[0])) {
            SolrCoreDescriptor.unpackSolrCoreDir(this.coreBundle, coreDir);
        } else {
            SolrCoreDescriptor.unpackSolrCoreZip(this.coreBundle, coreDir);
        }
    }

    @Override
    public int getNumShards() {
        return this.numShards;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public SimpleCoreDescriptor setNumShards(int numShards) {
        this.numShards = numShards;
        return this;
    }

    public SimpleCoreDescriptor setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public static SolrCoreDescriptor createFromResource(String coreName, String resource, Object contextObject) {
        return SimpleCoreDescriptor.createFromResource(coreName, resource, contextObject.getClass());
    }

    public static SolrCoreDescriptor createFromResource(String coreName, String resource, Class<?> clazz) {
        return new SimpleCoreDescriptor(coreName, ResourceLoaderUtils.getResourceAsPath((String)resource, clazz));
    }

    public static SolrCoreDescriptor createFromResource(String coreName, String resource, ClassLoader classLoader) {
        return new SimpleCoreDescriptor(coreName, ResourceLoaderUtils.getResourceAsPath((String)resource, (ClassLoader)classLoader));
    }
}

