/*
 * Decompiled with CFR 0.152.
 */
package io.redlink.solrlib;

import io.redlink.solrlib.SolrCoreDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrCoreContainer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Optional<ExecutorService> executorService;
    private final CountDownLatch startupComplete;
    private final Map<String, CountDownLatch> coreInitialized;
    private final AtomicBoolean initStarted;
    private Throwable initException = null;
    protected final Map<String, Throwable> coreInitException = new HashMap<String, Throwable>();
    protected final Set<SolrCoreDescriptor> coreDescriptors;
    protected final Map<String, SolrCoreDescriptor> availableCores = new HashMap<String, SolrCoreDescriptor>();

    public SolrCoreContainer(Set<SolrCoreDescriptor> coreDescriptors, ExecutorService executorService) {
        this.executorService = Optional.ofNullable(executorService);
        this.startupComplete = new CountDownLatch(1);
        this.coreInitialized = new HashMap<String, CountDownLatch>();
        this.initStarted = new AtomicBoolean(false);
        this.coreDescriptors = coreDescriptors;
    }

    public final void initialize() {
        if (this.initStarted.compareAndSet(false, true)) {
            long initStart = System.currentTimeMillis();
            this.log.debug("Initializing SolrCoreContainer");
            ExecutorService executorService = this.executorService.orElseGet(Executors::newSingleThreadExecutor);
            executorService.execute(() -> {
                try {
                    this.init(executorService);
                }
                catch (IOException | SolrServerException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error("Error while initializing SolrCoreContainer: {}", (Object)e.getMessage(), (Object)e);
                    } else {
                        this.log.error("Error while initializing SolrCoreContainer: {}", (Object)e.getMessage());
                    }
                    this.initException = e;
                }
                catch (Throwable t) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error("Unexpected Error while initializing SolrCoreContainer: {}", (Object)t.getMessage(), (Object)t);
                    } else {
                        this.log.error("Unexpected Error while initializing SolrCoreContainer: {}", (Object)t.getMessage());
                    }
                    this.initException = t;
                }
                finally {
                    long initDuration = System.currentTimeMillis() - initStart;
                    this.startupComplete.countDown();
                    this.log.debug("SolrCoreContainer initialized in {}ms", (Object)initDuration);
                    if (!this.executorService.isPresent()) {
                        executorService.shutdown();
                    }
                }
            });
        } else if (this.log.isDebugEnabled()) {
            this.log.warn("SolrCoreContainer was already initialized, ignoring call. You might have a flaw in your implementation flow...");
            this.log.debug("Double initialization call, not an error!", new Throwable("SolrCoreContainer already initialized"));
        } else {
            this.log.warn("SolrCoreContainer was already initialized, ignoring call.");
        }
    }

    protected abstract void init(ExecutorService var1) throws IOException, SolrServerException;

    protected void scheduleCoreInit(ExecutorService executorService, SolrCoreDescriptor coreDescriptor, boolean newCore) {
        CountDownLatch coreLatch = this.coreInitialized.computeIfAbsent(coreDescriptor.getCoreName(), s -> new CountDownLatch(1));
        executorService.execute(() -> {
            try {
                this.awaitInitCompletion();
                try (SolrClient solrClient = this.createSolrClient(coreDescriptor.getCoreName());){
                    if (newCore) {
                        coreDescriptor.onCoreCreated(solrClient);
                    }
                    coreDescriptor.onCoreStarted(solrClient);
                }
                catch (IOException | SolrServerException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.warn("Error while initializing core {}: {}", new Object[]{coreDescriptor.getCoreName(), e.getMessage(), e});
                    }
                    this.coreInitException.put(coreDescriptor.getCoreName(), e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted!", e);
            }
            finally {
                coreLatch.countDown();
            }
        });
    }

    public void shutdown() throws IOException {
    }

    protected abstract SolrClient createSolrClient(String var1);

    public SolrClient getSolrClient(String coreName) throws SolrServerException {
        try {
            this.awaitInitCompletion();
            if (this.initException != null) {
                throw new SolrServerException("Exception initializing SolrCoreContainer", this.initException);
            }
            Throwable coreInitException = this.coreInitException.get(coreName);
            if (coreInitException != null) {
                throw new SolrServerException("Exception initializing core " + coreName, coreInitException);
            }
            this.awaitCoreInitCompletion(coreName);
            Throwable coreInitExceptionDuringCallback = this.coreInitException.get(coreName);
            if (coreInitExceptionDuringCallback != null) {
                throw new SolrServerException("Exception initializing core " + coreName, coreInitExceptionDuringCallback);
            }
            return this.createSolrClient(coreName);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Could not retrieve SolrClient '" + coreName + "'", e);
        }
    }

    protected void awaitInitCompletion() throws InterruptedException {
        this.startupComplete.await();
    }

    protected void awaitCoreInitCompletion(String coreName) throws InterruptedException {
        CountDownLatch coreLatch = this.coreInitialized.get(coreName);
        if (coreLatch == null) {
            throw new IllegalArgumentException("Unknown core: " + coreName);
        }
        coreLatch.await();
    }

    public SolrClient getSolrClient(SolrCoreDescriptor coreDescriptor) throws SolrServerException {
        return this.getSolrClient(coreDescriptor.getCoreName());
    }

    public boolean isStartupComplete() {
        try {
            return this.startupComplete.await(-1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean isCoreAvailable(String coreName) {
        return this.availableCores.containsKey(coreName);
    }

    public boolean isCoreAvailable(SolrCoreDescriptor coreDescriptor) {
        return this.isCoreAvailable(coreDescriptor.getCoreName());
    }
}

