/*
 * Copyright 2015 Realm Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.realm.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

/**
 * This class is used for holding the reference to the native pointers present in NativeObjects.
 * This is required as phantom references cannot access the original objects for this value.
 */
public abstract class NativeObjectReference extends PhantomReference<NativeObject> {

    // The pointer to the native object to be handled
    protected final long nativePointer;

    public NativeObjectReference(NativeObject referent, ReferenceQueue<? super NativeObject> referenceQueue) {
        super(referent, referenceQueue);
        nativePointer = referent.nativePointer;
    }

    /**
     * This method is called when this reference gets cleared.
     * Subclasses should implement this method to dealloc the native pointer.
     */
    protected abstract void cleanup();

    @Override
    public void clear() {
        cleanup();
        super.clear();
    }
}
