/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.rapidw.mqtt.client.v3_1_1.MqttChannelInitializer;
import io.rapidw.mqtt.client.v3_1_1.MqttConnection;
import io.rapidw.mqtt.client.v3_1_1.MqttConnectionOption;
import java.util.concurrent.ThreadFactory;

public class MqttV311Client {
    private EventLoopGroup eventLoopGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2, (ThreadFactory)new DefaultThreadFactory("mqtt", true));

    public MqttConnection newConnection(MqttConnectionOption connectionOption) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true);
        if (connectionOption.getTcpConnectTimeout() != 0L) {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionOption.getTcpConnectTimeout()));
        }
        MqttConnection connection = new MqttConnection(bootstrap, connectionOption);
        bootstrap.handler((ChannelHandler)new MqttChannelInitializer(connectionOption, connection.handler()));
        return connection;
    }
}

