/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.rapidw.mqtt.client.v3_1_1.MqttConnection;
import io.rapidw.mqtt.client.v3_1_1.handler.MqttMessageHandler;
import io.rapidw.mqtt.client.v3_1_1.handler.MqttUnsubscribeResultHandler;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311QosLevel;

public class MqttSubscription {
    private MqttConnection connection;
    private String topicFilter;
    private MqttV311QosLevel qosLevel;
    private MqttMessageHandler messageHandler;

    MqttSubscription(MqttConnection connection, String topicFilter, MqttV311QosLevel qosLevel, MqttMessageHandler messageHandler) {
        this.connection = connection;
        this.topicFilter = topicFilter;
        this.qosLevel = qosLevel;
        this.messageHandler = messageHandler;
    }

    static MqttSubscriptionBuilder builder() {
        return new MqttSubscriptionBuilder();
    }

    public void unsubscribe(MqttUnsubscribeResultHandler unsubscribeResultHandler) {
        this.connection.unsubscribe(this, unsubscribeResultHandler);
    }

    MqttConnection getConnection() {
        return this.connection;
    }

    String getTopicFilter() {
        return this.topicFilter;
    }

    MqttV311QosLevel getQosLevel() {
        return this.qosLevel;
    }

    MqttMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    static class MqttSubscriptionBuilder {
        private MqttConnection connection;
        private String topicFilter;
        private MqttV311QosLevel qosLevel;
        private MqttMessageHandler messageHandler;

        MqttSubscriptionBuilder() {
        }

        MqttSubscriptionBuilder connection(MqttConnection connection) {
            this.connection = connection;
            return this;
        }

        MqttSubscriptionBuilder topicFilter(String topicFilter) {
            this.topicFilter = topicFilter;
            return this;
        }

        MqttSubscriptionBuilder qosLevel(MqttV311QosLevel qosLevel) {
            this.qosLevel = qosLevel;
            return this;
        }

        MqttSubscriptionBuilder messageHandler(MqttMessageHandler messageHandler) {
            this.messageHandler = messageHandler;
            return this;
        }

        MqttSubscription build() {
            return new MqttSubscription(this.connection, this.topicFilter, this.qosLevel, this.messageHandler);
        }

        public String toString() {
            return "MqttSubscription.MqttSubscriptionBuilder(connection=" + this.connection + ", topicFilter=" + this.topicFilter + ", qosLevel=" + this.qosLevel + ", messageHandler=" + this.messageHandler + ")";
        }
    }
}

