/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.rapidw.mqtt.client.v3_1_1.handler.MqttMessageHandler;
import io.rapidw.mqtt.client.v3_1_1.handler.MqttSubscribeResultHandler;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311TopicAndQosLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class MqttPendingSubscription {
    private MqttMessageHandler messageHandler;
    private List<MqttV311TopicAndQosLevel> topicAndQosLevels;
    private MqttSubscribeResultHandler mqttSubscribeResultHandler;

    MqttPendingSubscription(MqttMessageHandler messageHandler, List<MqttV311TopicAndQosLevel> topicAndQosLevels, MqttSubscribeResultHandler mqttSubscribeResultHandler) {
        this.messageHandler = messageHandler;
        this.topicAndQosLevels = topicAndQosLevels;
        this.mqttSubscribeResultHandler = mqttSubscribeResultHandler;
    }

    public static MqttPendingSubscriptionBuilder builder() {
        return new MqttPendingSubscriptionBuilder();
    }

    public MqttMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public List<MqttV311TopicAndQosLevel> getTopicAndQosLevels() {
        return this.topicAndQosLevels;
    }

    public MqttSubscribeResultHandler getMqttSubscribeResultHandler() {
        return this.mqttSubscribeResultHandler;
    }

    public static class MqttPendingSubscriptionBuilder {
        private MqttMessageHandler messageHandler;
        private ArrayList<MqttV311TopicAndQosLevel> topicAndQosLevels;
        private MqttSubscribeResultHandler mqttSubscribeResultHandler;

        MqttPendingSubscriptionBuilder() {
        }

        public MqttPendingSubscriptionBuilder messageHandler(MqttMessageHandler messageHandler) {
            this.messageHandler = messageHandler;
            return this;
        }

        public MqttPendingSubscriptionBuilder topicAndQosLevel(MqttV311TopicAndQosLevel topicAndQosLevel) {
            if (this.topicAndQosLevels == null) {
                this.topicAndQosLevels = new ArrayList();
            }
            this.topicAndQosLevels.add(topicAndQosLevel);
            return this;
        }

        public MqttPendingSubscriptionBuilder topicAndQosLevels(Collection<? extends MqttV311TopicAndQosLevel> topicAndQosLevels) {
            if (this.topicAndQosLevels == null) {
                this.topicAndQosLevels = new ArrayList();
            }
            this.topicAndQosLevels.addAll(topicAndQosLevels);
            return this;
        }

        public MqttPendingSubscriptionBuilder clearTopicAndQosLevels() {
            if (this.topicAndQosLevels != null) {
                this.topicAndQosLevels.clear();
            }
            return this;
        }

        public MqttPendingSubscriptionBuilder mqttSubscribeResultHandler(MqttSubscribeResultHandler mqttSubscribeResultHandler) {
            this.mqttSubscribeResultHandler = mqttSubscribeResultHandler;
            return this;
        }

        public MqttPendingSubscription build() {
            List<MqttV311TopicAndQosLevel> topicAndQosLevels;
            switch (this.topicAndQosLevels == null ? 0 : this.topicAndQosLevels.size()) {
                case 0: {
                    topicAndQosLevels = Collections.emptyList();
                    break;
                }
                case 1: {
                    topicAndQosLevels = Collections.singletonList(this.topicAndQosLevels.get(0));
                    break;
                }
                default: {
                    topicAndQosLevels = Collections.unmodifiableList(new ArrayList<MqttV311TopicAndQosLevel>(this.topicAndQosLevels));
                }
            }
            return new MqttPendingSubscription(this.messageHandler, topicAndQosLevels, this.mqttSubscribeResultHandler);
        }

        public String toString() {
            return "MqttPendingSubscription.MqttPendingSubscriptionBuilder(messageHandler=" + this.messageHandler + ", topicAndQosLevels=" + this.topicAndQosLevels + ", mqttSubscribeResultHandler=" + this.mqttSubscribeResultHandler + ")";
        }
    }
}

