/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.rapidw.mqtt.client.v3_1_1.handler.MqttPublishResultHandler;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311PublishPacket;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311QosLevel;

class MqttPendingMessage {
    private final MqttV311PublishPacket packet;
    private final MqttPublishResultHandler publishResultHandler;
    private final MqttV311QosLevel qosLevel;

    MqttPendingMessage(MqttV311PublishPacket packet, MqttPublishResultHandler publishResultHandler, MqttV311QosLevel qosLevel) {
        this.packet = packet;
        this.publishResultHandler = publishResultHandler;
        this.qosLevel = qosLevel;
    }

    public static MqttPendingMessageBuilder builder() {
        return new MqttPendingMessageBuilder();
    }

    public MqttV311PublishPacket getPacket() {
        return this.packet;
    }

    public MqttPublishResultHandler getPublishResultHandler() {
        return this.publishResultHandler;
    }

    public MqttV311QosLevel getQosLevel() {
        return this.qosLevel;
    }

    public static class MqttPendingMessageBuilder {
        private MqttV311PublishPacket packet;
        private MqttPublishResultHandler publishResultHandler;
        private MqttV311QosLevel qosLevel;

        MqttPendingMessageBuilder() {
        }

        public MqttPendingMessageBuilder packet(MqttV311PublishPacket packet) {
            this.packet = packet;
            return this;
        }

        public MqttPendingMessageBuilder publishResultHandler(MqttPublishResultHandler publishResultHandler) {
            this.publishResultHandler = publishResultHandler;
            return this;
        }

        public MqttPendingMessageBuilder qosLevel(MqttV311QosLevel qosLevel) {
            this.qosLevel = qosLevel;
            return this;
        }

        public MqttPendingMessage build() {
            return new MqttPendingMessage(this.packet, this.publishResultHandler, this.qosLevel);
        }
    }
}

