/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.rapidw.mqtt.client.v3_1_1.MqttClientException;
import io.rapidw.mqtt.client.v3_1_1.handler.MqttExceptionHandler;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311Will;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MqttConnectionOption {
    private final String host;
    private final int port;
    private final String username;
    private final byte[] password;
    private final MqttV311Will will;
    private final boolean cleanSession;
    private final long keepAliveSeconds;
    private final String clientId;
    private final byte[] serverCertificate;
    private final byte[] clientCertificate;
    private final long tcpConnectTimeout;
    private final long mqttConnectTimeout;
    private final MqttExceptionHandler exceptionHandler;

    MqttConnectionOption(String host, int port, String username, byte[] password, MqttV311Will will, boolean cleanSession, int keepAliveSeconds, String clientId, byte[] serverCertificate, byte[] clientCertificate, int tcpConnectTimeout, TimeUnit tcpConnectTimeoutTimeUnit, int mqttConnectTimeout, TimeUnit mqttConnectTimeoutTimeUnit, MqttExceptionHandler exceptionHandler) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.username = username;
        this.password = password;
        this.will = will;
        this.cleanSession = cleanSession;
        this.keepAliveSeconds = keepAliveSeconds;
        if (keepAliveSeconds < 0) {
            throw new MqttClientException("invalid keepAlive");
        }
        this.clientId = Objects.requireNonNull(clientId);
        this.serverCertificate = serverCertificate;
        this.clientCertificate = clientCertificate;
        if (tcpConnectTimeout < 0) {
            throw new MqttClientException("invalid tcpConnectTimeout");
        }
        if (tcpConnectTimeoutTimeUnit == null) {
            throw new MqttClientException("tcpConnectTimeoutTimeUnit required");
        }
        this.tcpConnectTimeout = TimeUnit.MILLISECONDS.convert(tcpConnectTimeout, tcpConnectTimeoutTimeUnit);
        if (mqttConnectTimeout < 0) {
            throw new MqttClientException("invalid mqttConnectTimeout");
        }
        if (mqttConnectTimeoutTimeUnit == null) {
            throw new MqttClientException("mqttConnectTimeoutTimeUnit required");
        }
        this.mqttConnectTimeout = TimeUnit.MILLISECONDS.convert(mqttConnectTimeout, mqttConnectTimeoutTimeUnit);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    public static MqttConnectionOptionBuilder builder() {
        return new MqttConnectionOptionBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public MqttV311Will getWill() {
        return this.will;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public String getClientId() {
        return this.clientId;
    }

    public byte[] getServerCertificate() {
        return this.serverCertificate;
    }

    public byte[] getClientCertificate() {
        return this.clientCertificate;
    }

    public long getTcpConnectTimeout() {
        return this.tcpConnectTimeout;
    }

    public long getMqttConnectTimeout() {
        return this.mqttConnectTimeout;
    }

    public MqttExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public static class MqttConnectionOptionBuilder {
        private String host;
        private int port;
        private String username;
        private byte[] password;
        private MqttV311Will will;
        private boolean cleanSession;
        private int keepAliveSeconds;
        private String clientId;
        private byte[] serverCertificate;
        private byte[] clientCertificate;
        private int tcpConnectTimeout;
        private TimeUnit tcpConnectTimeoutTimeUnit;
        private int mqttConnectTimeout;
        private TimeUnit mqttConnectTimeoutTimeUnit;
        private MqttExceptionHandler exceptionHandler;

        MqttConnectionOptionBuilder() {
        }

        public MqttConnectionOptionBuilder host(String host) {
            this.host = Objects.requireNonNull(host);
            return this;
        }

        public MqttConnectionOptionBuilder port(int port) {
            this.port = port;
            return this;
        }

        public MqttConnectionOptionBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MqttConnectionOptionBuilder password(byte[] password) {
            this.password = password;
            return this;
        }

        public MqttConnectionOptionBuilder will(MqttV311Will will) {
            this.will = will;
            return this;
        }

        public MqttConnectionOptionBuilder cleanSession(boolean cleanSession) {
            this.cleanSession = cleanSession;
            return this;
        }

        public MqttConnectionOptionBuilder keepAliveSeconds(int keepAliveSeconds) {
            this.keepAliveSeconds = keepAliveSeconds;
            return this;
        }

        public MqttConnectionOptionBuilder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId);
            return this;
        }

        public MqttConnectionOptionBuilder serverCertificate(byte[] serverCertificate) {
            this.serverCertificate = serverCertificate;
            return this;
        }

        public MqttConnectionOptionBuilder clientCertificate(byte[] clientCertificate) {
            this.clientCertificate = clientCertificate;
            return this;
        }

        public MqttConnectionOptionBuilder tcpConnectTimeout(int tcpConnectTimeout, TimeUnit tcpConnectTimeoutTimeUnit) {
            this.tcpConnectTimeout = tcpConnectTimeout;
            this.tcpConnectTimeoutTimeUnit = tcpConnectTimeoutTimeUnit;
            return this;
        }

        public MqttConnectionOptionBuilder mqttConnectTimeout(int mqttConnectTimeout, TimeUnit mqttConnectTimeoutTimeUnit) {
            this.mqttConnectTimeout = mqttConnectTimeout;
            this.mqttConnectTimeoutTimeUnit = mqttConnectTimeoutTimeUnit;
            return this;
        }

        public MqttConnectionOptionBuilder exceptionHandler(MqttExceptionHandler exceptionHandler) {
            this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
            return this;
        }

        public MqttConnectionOption build() {
            return new MqttConnectionOption(this.host, this.port, this.username, this.password, this.will, this.cleanSession, this.keepAliveSeconds, this.clientId, this.serverCertificate, this.clientCertificate, this.tcpConnectTimeout, this.tcpConnectTimeoutTimeUnit, this.mqttConnectTimeout, this.mqttConnectTimeoutTimeUnit, this.exceptionHandler);
        }
    }
}

