/*
 * Decompiled with CFR 0.152.
 */
package io.rapidw.mqtt.client.v3_1_1;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.rapidw.mqtt.client.v3_1_1.MqttConnection;
import io.rapidw.mqtt.client.v3_1_1.MqttConnectionOption;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311Decoder;
import io.rapidw.mqtt.codec.v3_1_1.MqttV311Encoder;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManagerFactory;

class MqttChannelInitializer
extends ChannelInitializer<NioSocketChannel> {
    private final MqttConnection.Handler handler;
    private MqttConnectionOption connectionOption;

    public MqttChannelInitializer(MqttConnectionOption connectionOption, MqttConnection.Handler handler) {
        this.connectionOption = connectionOption;
        this.handler = handler;
    }

    protected void initChannel(NioSocketChannel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        byte[] sslCertificateBytes = this.connectionOption.getServerCertificate();
        if (sslCertificateBytes != null) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(sslCertificateBytes));
            String alias = cert.getSubjectX500Principal().getName();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry(alias, cert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SslContext sslContext = SslContextBuilder.forClient().trustManager(tmf).startTls(false).build();
            pipeline.addFirst(new ChannelHandler[]{sslContext.newHandler(channel.alloc(), this.connectionOption.getHost(), this.connectionOption.getPort())});
        }
        pipeline.addLast(new ChannelHandler[]{new MqttV311Decoder()});
        pipeline.addLast(new ChannelHandler[]{MqttV311Encoder.INSTANCE});
        pipeline.addLast("mqtt_client_handler", (ChannelHandler)this.handler);
    }
}

