/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.text.TextUtils;
import io.rakam.api.RakamLog;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Identify {
    public static final String TAG = "Identify";
    protected JSONObject userPropertiesOperations = new JSONObject();
    protected Set<String> userProperties = new HashSet<String>();

    public Identify setOnce(String property, boolean value) {
        this.addToUserProperties("set_properties_once", property, value);
        return this;
    }

    public Identify setOnce(String property, double value) {
        this.addToUserProperties("set_properties_once", property, value);
        return this;
    }

    public Identify setOnce(String property, float value) {
        this.addToUserProperties("set_properties_once", property, Float.valueOf(value));
        return this;
    }

    public Identify setOnce(String property, int value) {
        this.addToUserProperties("set_properties_once", property, value);
        return this;
    }

    public Identify setOnce(String property, long value) {
        this.addToUserProperties("set_properties_once", property, value);
        return this;
    }

    public Identify setOnce(String property, String value) {
        this.addToUserProperties("set_properties_once", property, value);
        return this;
    }

    public Identify setOnce(String property, JSONArray values) {
        this.addToUserProperties("set_properties_once", property, values);
        return this;
    }

    public Identify setOnce(String property, JSONObject values) {
        this.addToUserProperties("set_properties_once", property, values);
        return this;
    }

    public Identify setOnce(String property, boolean[] values) {
        this.addToUserProperties("set_properties_once", property, this.booleanArrayToJSONArray(values));
        return this;
    }

    public Identify setOnce(String property, double[] values) {
        this.addToUserProperties("set_properties_once", property, this.doubleArrayToJSONArray(values));
        return this;
    }

    public Identify setOnce(String property, float[] values) {
        this.addToUserProperties("set_properties_once", property, this.floatArrayToJSONArray(values));
        return this;
    }

    public Identify setOnce(String property, int[] values) {
        this.addToUserProperties("set_properties_once", property, this.intArrayToJSONArray(values));
        return this;
    }

    public Identify setOnce(String property, long[] values) {
        this.addToUserProperties("set_properties_once", property, this.longArrayToJSONArray(values));
        return this;
    }

    public Identify setOnce(String property, String[] values) {
        this.addToUserProperties("set_properties_once", property, this.stringArrayToJSONArray(values));
        return this;
    }

    public Identify set(String property, boolean value) {
        this.addToUserProperties("set_properties", property, value);
        return this;
    }

    public Identify set(String property, double value) {
        this.addToUserProperties("set_properties", property, value);
        return this;
    }

    public Identify set(String property, float value) {
        this.addToUserProperties("set_properties", property, Float.valueOf(value));
        return this;
    }

    public Identify set(String property, int value) {
        this.addToUserProperties("set_properties", property, value);
        return this;
    }

    public Identify set(String property, long value) {
        this.addToUserProperties("set_properties", property, value);
        return this;
    }

    public Identify set(String property, String value) {
        this.addToUserProperties("set_properties", property, value);
        return this;
    }

    public Identify set(String property, JSONObject values) {
        this.addToUserProperties("set_properties", property, values);
        return this;
    }

    public Identify set(String property, JSONArray values) {
        this.addToUserProperties("set_properties", property, values);
        return this;
    }

    public Identify set(String property, boolean[] values) {
        this.addToUserProperties("set_properties", property, this.booleanArrayToJSONArray(values));
        return this;
    }

    public Identify set(String property, double[] values) {
        this.addToUserProperties("set_properties", property, this.doubleArrayToJSONArray(values));
        return this;
    }

    public Identify set(String property, float[] values) {
        this.addToUserProperties("set_properties", property, this.floatArrayToJSONArray(values));
        return this;
    }

    public Identify set(String property, int[] values) {
        this.addToUserProperties("set_properties", property, this.intArrayToJSONArray(values));
        return this;
    }

    public Identify set(String property, long[] values) {
        this.addToUserProperties("set_properties", property, this.longArrayToJSONArray(values));
        return this;
    }

    public Identify set(String property, String[] values) {
        this.addToUserProperties("set_properties", property, this.stringArrayToJSONArray(values));
        return this;
    }

    public Identify add(String property, double value) {
        this.addToUserProperties("increment_properties", property, value);
        return this;
    }

    public Identify add(String property, float value) {
        this.addToUserProperties("increment_properties", property, Float.valueOf(value));
        return this;
    }

    public Identify add(String property, int value) {
        this.addToUserProperties("increment_properties", property, value);
        return this;
    }

    public Identify add(String property, long value) {
        this.addToUserProperties("increment_properties", property, value);
        return this;
    }

    public Identify add(String property, String value) {
        this.addToUserProperties("increment_properties", property, value);
        return this;
    }

    public Identify add(String property, JSONObject values) {
        this.addToUserProperties("increment_properties", property, values);
        return this;
    }

    public Identify unset(String property) {
        this.addToUserProperties("unset_properties", property, null);
        return this;
    }

    public Identify clearAll() {
        if (this.userPropertiesOperations.length() > 0) {
            if (!this.userProperties.contains("clear_all_properties")) {
                RakamLog.getLogger().w(TAG, String.format("Need to send $clearAll on its own Identify object without any other operations, ignoring $clearAll", new Object[0]));
            }
            return this;
        }
        try {
            this.userPropertiesOperations.put("clear_all_properties", 1);
        }
        catch (JSONException e) {
            RakamLog.getLogger().e(TAG, e.toString());
        }
        return this;
    }

    private void addToUserProperties(String operation, String property, Object value) {
        if (TextUtils.isEmpty((CharSequence)property)) {
            RakamLog.getLogger().w(TAG, String.format("Attempting to perform operation %s with a null or empty string property, ignoring", operation));
            return;
        }
        if (operation != "unset_properties" && value == null) {
            RakamLog.getLogger().w(TAG, String.format("Attempting to perform operation %s with null value for property %s, ignoring", operation, property));
            return;
        }
        if (this.userPropertiesOperations.has("clear_all_properties")) {
            RakamLog.getLogger().w(TAG, String.format("This Identify already contains a $clearAll operation, ignoring operation %s", operation));
            return;
        }
        if (this.userProperties.contains(property)) {
            RakamLog.getLogger().w(TAG, String.format("Already used property %s in previous operation, ignoring operation %s", property, operation));
            return;
        }
        try {
            if (!this.userPropertiesOperations.has(operation)) {
                this.userPropertiesOperations.put(operation, operation != "unset_properties" ? new JSONObject() : new JSONArray());
            }
            if (operation != "unset_properties") {
                this.userPropertiesOperations.getJSONObject(operation).put(property, value);
            } else {
                this.userPropertiesOperations.getJSONArray(operation).put((Object)property);
            }
            this.userProperties.add(property);
        }
        catch (JSONException e) {
            RakamLog.getLogger().e(TAG, e.toString());
        }
    }

    private JSONArray booleanArrayToJSONArray(boolean[] values) {
        JSONArray array = new JSONArray();
        for (boolean value : values) {
            array.put(value);
        }
        return array;
    }

    private JSONArray floatArrayToJSONArray(float[] values) {
        JSONArray array = new JSONArray();
        for (float value : values) {
            try {
                array.put((double)value);
            }
            catch (JSONException e) {
                RakamLog.getLogger().e(TAG, String.format("Error converting float %f to JSON: %s", Float.valueOf(value), e.toString()));
            }
        }
        return array;
    }

    private JSONArray doubleArrayToJSONArray(double[] values) {
        JSONArray array = new JSONArray();
        for (double value : values) {
            try {
                array.put(value);
            }
            catch (JSONException e) {
                RakamLog.getLogger().e(TAG, String.format("Error converting double %d to JSON: %s", value, e.toString()));
            }
        }
        return array;
    }

    private JSONArray intArrayToJSONArray(int[] values) {
        JSONArray array = new JSONArray();
        for (int value : values) {
            array.put(value);
        }
        return array;
    }

    private JSONArray longArrayToJSONArray(long[] values) {
        JSONArray array = new JSONArray();
        for (long value : values) {
            array.put(value);
        }
        return array;
    }

    private JSONArray stringArrayToJSONArray(String[] values) {
        JSONArray array = new JSONArray();
        for (String value : values) {
            array.put((Object)value);
        }
        return array;
    }

    Identify setUserProperty(String property, Object value) {
        this.addToUserProperties("set_properties", property, value);
        return this;
    }
}

