/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import io.rakam.api.RakamLog;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class DeviceInfo {
    public static final String TAG = "DeviceInfo";
    public static final String OS_NAME = "android";
    private boolean locationListening = true;
    private Context context;
    private CachedInfo cachedInfo;

    public DeviceInfo(Context context) {
        this.context = context;
    }

    private CachedInfo getCachedInfo() {
        if (this.cachedInfo == null) {
            this.cachedInfo = new CachedInfo();
        }
        return this.cachedInfo;
    }

    public void prefetch() {
        this.getCachedInfo();
    }

    public String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public String getVersionName() {
        return this.getCachedInfo().versionName;
    }

    public String getOsName() {
        return this.getCachedInfo().osName;
    }

    public String getOsVersion() {
        return this.getCachedInfo().osVersion;
    }

    public String getBrand() {
        return this.getCachedInfo().brand;
    }

    public String getManufacturer() {
        return this.getCachedInfo().manufacturer;
    }

    public String getModel() {
        return this.getCachedInfo().model;
    }

    public String getCarrier() {
        return this.getCachedInfo().carrier;
    }

    public String getCountry() {
        return this.getCachedInfo().country;
    }

    public String getLanguage() {
        return this.getCachedInfo().language;
    }

    public String getAdvertisingId() {
        return this.getCachedInfo().advertisingId;
    }

    public boolean isLimitAdTrackingEnabled() {
        return this.getCachedInfo().limitAdTrackingEnabled;
    }

    public boolean isGooglePlayServicesEnabled() {
        return this.getCachedInfo().gpsEnabled;
    }

    public Location getMostRecentLocation() {
        if (!this.isLocationListening()) {
            return null;
        }
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        if (locationManager == null) {
            return null;
        }
        List providers = null;
        try {
            providers = locationManager.getProviders(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (providers == null) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String provider : providers) {
            Location location = null;
            try {
                location = locationManager.getLastKnownLocation(provider);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (location == null) continue;
            locations.add(location);
        }
        long maximumTimestamp = -1L;
        Location bestLocation = null;
        for (Location location : locations) {
            if (location.getTime() <= maximumTimestamp) continue;
            maximumTimestamp = location.getTime();
            bestLocation = location;
        }
        return bestLocation;
    }

    public boolean isLocationListening() {
        return this.locationListening;
    }

    public void setLocationListening(boolean locationListening) {
        this.locationListening = locationListening;
    }

    protected Geocoder getGeocoder() {
        return new Geocoder(this.context, Locale.ENGLISH);
    }

    private class CachedInfo {
        private String advertisingId = this.getAdvertisingId();
        private String country;
        private String versionName = this.getVersionName();
        private String osName = this.getOsName();
        private String osVersion = this.getOsVersion();
        private String brand = this.getBrand();
        private String manufacturer = this.getManufacturer();
        private String model = this.getModel();
        private String carrier = this.getCarrier();
        private String language;
        private boolean limitAdTrackingEnabled;
        private boolean gpsEnabled;

        private CachedInfo() {
            this.country = this.getCountry();
            this.language = this.getLanguage();
            this.gpsEnabled = this.checkGPSEnabled();
        }

        private String getVersionName() {
            try {
                PackageInfo packageInfo = DeviceInfo.this.context.getPackageManager().getPackageInfo(DeviceInfo.this.context.getPackageName(), 0);
                return packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private String getOsName() {
            return DeviceInfo.OS_NAME;
        }

        private String getOsVersion() {
            return Build.VERSION.RELEASE;
        }

        private String getBrand() {
            return Build.BRAND;
        }

        private String getManufacturer() {
            return Build.MANUFACTURER;
        }

        private String getModel() {
            return Build.MODEL;
        }

        private String getCarrier() {
            TelephonyManager manager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
            return manager.getNetworkOperatorName();
        }

        private String getCountry() {
            String country = this.getCountryFromLocation();
            if (!TextUtils.isEmpty((CharSequence)country)) {
                return country;
            }
            country = this.getCountryFromNetwork();
            if (!TextUtils.isEmpty((CharSequence)country)) {
                return country;
            }
            return this.getCountryFromLocale();
        }

        private String getCountryFromLocation() {
            if (!DeviceInfo.this.isLocationListening()) {
                return null;
            }
            Location recent = DeviceInfo.this.getMostRecentLocation();
            if (recent != null) {
                try {
                    Geocoder geocoder;
                    List addresses;
                    if (Geocoder.isPresent() && (addresses = (geocoder = DeviceInfo.this.getGeocoder()).getFromLocation(recent.getLatitude(), recent.getLongitude(), 1)) != null) {
                        for (Address address : addresses) {
                            if (address == null) continue;
                            return address.getCountryCode();
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return null;
        }

        private String getCountryFromNetwork() {
            try {
                String country;
                TelephonyManager manager = (TelephonyManager)DeviceInfo.this.context.getSystemService("phone");
                if (manager.getPhoneType() != 2 && (country = manager.getNetworkCountryIso()) != null) {
                    return country.toUpperCase(Locale.US);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private String getCountryFromLocale() {
            return Locale.getDefault().getCountry();
        }

        private String getLanguage() {
            return Locale.getDefault().getLanguage();
        }

        private String getAdvertisingId() {
            try {
                Class<?> AdvertisingIdClient = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                Method getAdvertisingInfo = AdvertisingIdClient.getMethod("getAdvertisingIdInfo", Context.class);
                Object advertisingInfo = getAdvertisingInfo.invoke(null, DeviceInfo.this.context);
                Method isLimitAdTrackingEnabled = advertisingInfo.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
                Boolean limitAdTrackingEnabled = (Boolean)isLimitAdTrackingEnabled.invoke(advertisingInfo, new Object[0]);
                this.limitAdTrackingEnabled = limitAdTrackingEnabled != null && limitAdTrackingEnabled != false;
                Method getId = advertisingInfo.getClass().getMethod("getId", new Class[0]);
                this.advertisingId = (String)getId.invoke(advertisingInfo, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services SDK not found!");
            }
            catch (InvocationTargetException e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services not available");
            }
            catch (Exception e) {
                RakamLog.getLogger().e(DeviceInfo.TAG, "Encountered an error connecting to Google Play Services", e);
            }
            return this.advertisingId;
        }

        private boolean checkGPSEnabled() {
            try {
                Class<?> GPSUtil = Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
                Method getGPSAvailable = GPSUtil.getMethod("isGooglePlayServicesAvailable", Context.class);
                Integer status = (Integer)getGPSAvailable.invoke(null, DeviceInfo.this.context);
                return status != null && status == 0;
            }
            catch (NoClassDefFoundError e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services Util not found!");
            }
            catch (ClassNotFoundException e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services Util not found!");
            }
            catch (NoSuchMethodException e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services not available");
            }
            catch (InvocationTargetException e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services not available");
            }
            catch (IllegalAccessException e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Google Play Services not available");
            }
            catch (Exception e) {
                RakamLog.getLogger().w(DeviceInfo.TAG, "Error when checking for Google Play Services: " + e);
            }
            return false;
        }
    }
}

