/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.sqlite.SQLiteDatabase;
import android.location.Location;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import io.rakam.api.Constants;
import io.rakam.api.CursorWindowAllocationException;
import io.rakam.api.DatabaseHelper;
import io.rakam.api.DatabaseResetListener;
import io.rakam.api.DeviceInfo;
import io.rakam.api.Diagnostics;
import io.rakam.api.Identify;
import io.rakam.api.RakamCallbacks;
import io.rakam.api.RakamLog;
import io.rakam.api.Revenue;
import io.rakam.api.TrackingOptions;
import io.rakam.api.Utils;
import io.rakam.api.WorkerThread;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RakamClient {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String TAG = "RakamClient";
    public static final String START_SESSION_EVENT = "_session_start";
    public static final String END_SESSION_EVENT = "_session_end";
    public static final String DEVICE_ID_KEY = "device_id";
    public static final String USER_ID_KEY = "user_id";
    public static final String SUPER_PROPERTIES_KEY = "super_properties";
    public static final String OPT_OUT_KEY = "opt_out";
    public static final String LAST_EVENT_TIME_KEY = "last_event_time";
    public static final String LAST_EVENT_ID_KEY = "last_event_id";
    public static final String LAST_IDENTIFY_ID_KEY = "last_identify_id";
    public static final String PREVIOUS_SESSION_ID_KEY = "previous_session_id";
    private static final RakamLog logger = RakamLog.getLogger();
    protected Context context;
    protected OkHttpClient httpClient;
    protected DatabaseHelper dbHelper;
    protected String apiKey;
    protected String instanceName;
    protected String userId;
    protected String deviceId;
    private boolean newDeviceIdPerInstall = false;
    private boolean useAdvertisingIdForDeviceId = false;
    protected boolean initialized = false;
    private boolean optOut = false;
    private boolean offline = false;
    TrackingOptions trackingOptions = new TrackingOptions();
    JSONObject apiPropertiesTrackingOptions;
    protected String platform;
    long sessionId = -1L;
    long lastEventId = -1L;
    long lastIdentifyId = -1L;
    long lastEventTime = -1L;
    long previousSessionId = -1L;
    private DeviceInfo deviceInfo;
    private int eventUploadThreshold = 30;
    private int eventUploadMaxBatchSize = 100;
    private int eventMaxCount = 1000;
    private long eventUploadPeriodMillis = 30000L;
    private long minTimeBetweenSessionsMillis = 300000L;
    private long sessionTimeoutMillis = 1800000L;
    private boolean backoffUpload = false;
    private int backoffUploadBatchSize = this.eventUploadMaxBatchSize;
    private boolean usingForegroundTracking = false;
    private boolean trackingSessionEvents = false;
    private boolean inForeground = false;
    private JSONObject superProperties;
    private boolean flushEventsOnClose = true;
    private AtomicBoolean updateScheduled = new AtomicBoolean(false);
    AtomicBoolean uploadingCurrently = new AtomicBoolean(false);
    Throwable lastError;
    private String apiUrl;
    WorkerThread logThread = new WorkerThread("logThread");
    WorkerThread httpThread = new WorkerThread("httpThread");

    public RakamClient() {
        this(null);
    }

    public RakamClient(String instance) {
        this.instanceName = Utils.normalizeInstanceName(instance);
        this.logThread.start();
        this.httpThread.start();
        this.logThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.e(RakamClient.TAG, "Unknown exception thrown from log thread.", e);
            }
        });
        this.httpThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.e(RakamClient.TAG, "Unknown exception thrown from HTTP thread.", e);
            }
        });
    }

    public RakamClient initialize(Context context, URL apiUrl, String apiKey) {
        return this.initialize(context, apiUrl, apiKey, null);
    }

    public synchronized RakamClient initialize(Context context, URL apiUrl, String apiKey, String userId) {
        return this.initialize(context, apiUrl, apiKey, userId, null, true);
    }

    public synchronized RakamClient initialize(final Context context, URL apiUrl, final String apiKey, final String userId, String platform, final boolean enableDiagnosticLogging) {
        if (context == null) {
            logger.e(TAG, "Argument context cannot be null in initialize()");
            return this;
        }
        this.setApiUrl(apiUrl);
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            logger.e(TAG, "Argument apiKey cannot be null or blank in initialize()");
            return this;
        }
        this.context = context.getApplicationContext();
        this.apiKey = apiKey;
        this.dbHelper = DatabaseHelper.getDatabaseHelper(this.context, this.instanceName);
        this.platform = Utils.isEmptyString(platform) ? "Android" : platform;
        final RakamClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (!RakamClient.this.initialized) {
                    try {
                        if (RakamClient.this.instanceName.equals("$default_instance")) {
                            RakamClient.upgradePrefs(context);
                            RakamClient.upgradeSharedPrefsToDB(context);
                        }
                        RakamClient.this.httpClient = new OkHttpClient();
                        RakamClient.this.deviceInfo = new DeviceInfo(context);
                        RakamClient.this.deviceId = RakamClient.this.initializeDeviceId();
                        if (enableDiagnosticLogging) {
                            Diagnostics.getLogger().enableLogging(RakamClient.this.httpClient, apiKey, RakamClient.this.deviceId);
                        }
                        RakamClient.this.deviceInfo.prefetch();
                        if (userId != null) {
                            client.userId = userId;
                            RakamClient.this.dbHelper.insertOrReplaceKeyValue(RakamClient.USER_ID_KEY, userId);
                        } else {
                            client.userId = RakamClient.this.dbHelper.getValue(RakamClient.USER_ID_KEY);
                        }
                        Long optOutLong = RakamClient.this.dbHelper.getLongValue(RakamClient.OPT_OUT_KEY);
                        RakamClient.this.optOut = optOutLong != null && optOutLong == 1L;
                        RakamClient.this.previousSessionId = RakamClient.this.getLongvalue(RakamClient.PREVIOUS_SESSION_ID_KEY, -1L);
                        if (RakamClient.this.previousSessionId >= 0L) {
                            RakamClient.this.sessionId = RakamClient.this.previousSessionId;
                        }
                        RakamClient.this.lastEventId = RakamClient.this.getLongvalue(RakamClient.LAST_EVENT_ID_KEY, -1L);
                        RakamClient.this.lastIdentifyId = RakamClient.this.getLongvalue(RakamClient.LAST_IDENTIFY_ID_KEY, -1L);
                        RakamClient.this.lastEventTime = RakamClient.this.getLongvalue(RakamClient.LAST_EVENT_TIME_KEY, -1L);
                        RakamClient.this.dbHelper.setDatabaseResetListener(new DatabaseResetListener(){

                            @Override
                            public void onDatabaseReset(SQLiteDatabase db) {
                                RakamClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "store", RakamClient.DEVICE_ID_KEY, client.deviceId);
                                RakamClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "store", RakamClient.USER_ID_KEY, client.userId);
                                RakamClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "long_store", RakamClient.OPT_OUT_KEY, client.optOut ? 1L : 0L);
                                RakamClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "long_store", RakamClient.PREVIOUS_SESSION_ID_KEY, client.sessionId);
                                RakamClient.this.dbHelper.insertOrReplaceKeyValueToTable(db, "long_store", RakamClient.LAST_EVENT_TIME_KEY, client.lastEventTime);
                            }
                        });
                        RakamClient.this.initialized = true;
                        String value = RakamClient.this.dbHelper.getValue(RakamClient.SUPER_PROPERTIES_KEY);
                        if (value != null) {
                            try {
                                RakamClient.this.superProperties = new JSONObject(value);
                            }
                            catch (JSONException e) {
                                RakamClient.this.dbHelper.insertOrReplaceKeyValue(RakamClient.SUPER_PROPERTIES_KEY, null);
                            }
                        }
                    }
                    catch (CursorWindowAllocationException e) {
                        logger.e(RakamClient.TAG, String.format("Failed to initialize Rakam SDK due to: %s", e.getMessage()));
                        Diagnostics.getLogger().logError("Failed to initialize Rakam SDK", e);
                        client.apiKey = null;
                    }
                }
            }
        });
        return this;
    }

    public RakamClient setSuperProperties(JSONObject superProperties) {
        this.superProperties = superProperties;
        this.dbHelper.insertOrReplaceKeyValue(SUPER_PROPERTIES_KEY, superProperties.toString());
        return this;
    }

    public JSONObject getSuperProperties() {
        return Utils.cloneJSONObject(this.superProperties);
    }

    public RakamClient enableForegroundTracking(Application app) {
        if (this.usingForegroundTracking || !this.contextAndApiKeySet("enableForegroundTracking()")) {
            return this;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new RakamCallbacks(this));
        }
        return this;
    }

    public RakamClient enableDiagnosticLogging() {
        if (!this.contextAndApiKeySet("enableDiagnosticLogging")) {
            return this;
        }
        Diagnostics.getLogger().enableLogging(this.httpClient, this.apiKey, this.deviceId);
        return this;
    }

    public RakamClient disableDiagnosticLogging() {
        Diagnostics.getLogger().disableLogging();
        return this;
    }

    public RakamClient setDiagnosticEventMaxCount(int eventMaxCount) {
        Diagnostics.getLogger().setDiagnosticEventMaxCount(eventMaxCount);
        return this;
    }

    public RakamClient enableNewDeviceIdPerInstall(boolean newDeviceIdPerInstall) {
        this.newDeviceIdPerInstall = newDeviceIdPerInstall;
        return this;
    }

    public RakamClient useAdvertisingIdForDeviceId() {
        this.useAdvertisingIdForDeviceId = true;
        return this;
    }

    public RakamClient enableLocationListening() {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (RakamClient.this.deviceInfo == null) {
                    throw new IllegalStateException("Must initialize before acting on location listening.");
                }
                RakamClient.this.deviceInfo.setLocationListening(true);
            }
        });
        return this;
    }

    public RakamClient disableLocationListening() {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (RakamClient.this.deviceInfo == null) {
                    throw new IllegalStateException("Must initialize before acting on location listening.");
                }
                RakamClient.this.deviceInfo.setLocationListening(false);
            }
        });
        return this;
    }

    public RakamClient setEventUploadThreshold(int eventUploadThreshold) {
        this.eventUploadThreshold = eventUploadThreshold;
        return this;
    }

    public RakamClient setEventUploadMaxBatchSize(int eventUploadMaxBatchSize) {
        this.eventUploadMaxBatchSize = eventUploadMaxBatchSize;
        this.backoffUploadBatchSize = eventUploadMaxBatchSize;
        return this;
    }

    public RakamClient setEventMaxCount(int eventMaxCount) {
        this.eventMaxCount = eventMaxCount;
        return this;
    }

    public RakamClient setEventUploadPeriodMillis(int eventUploadPeriodMillis) {
        this.eventUploadPeriodMillis = eventUploadPeriodMillis;
        return this;
    }

    public RakamClient setMinTimeBetweenSessionsMillis(long minTimeBetweenSessionsMillis) {
        this.minTimeBetweenSessionsMillis = minTimeBetweenSessionsMillis;
        return this;
    }

    public RakamClient setSessionTimeoutMillis(long sessionTimeoutMillis) {
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        return this;
    }

    public RakamClient setTrackingOptions(TrackingOptions trackingOptions) {
        this.trackingOptions = trackingOptions;
        this.apiPropertiesTrackingOptions = trackingOptions.getApiPropertiesTrackingOptions();
        return this;
    }

    public RakamClient setOptOut(final boolean optOut) {
        if (!this.contextAndApiKeySet("setOptOut()")) {
            return this;
        }
        final RakamClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(RakamClient.this.apiKey)) {
                    return;
                }
                client.optOut = optOut;
                RakamClient.this.dbHelper.insertOrReplaceKeyLongValue(RakamClient.OPT_OUT_KEY, optOut ? 1L : 0L);
            }
        });
        return this;
    }

    public boolean isOptedOut() {
        return this.optOut;
    }

    public RakamClient enableLogging(boolean enableLogging) {
        logger.setEnableLogging(enableLogging);
        return this;
    }

    public RakamClient setLogLevel(int logLevel) {
        logger.setLogLevel(logLevel);
        return this;
    }

    public RakamClient setOffline(boolean offline) {
        this.offline = offline;
        if (!offline) {
            this.uploadEvents();
        }
        return this;
    }

    public RakamClient setFlushEventsOnClose(boolean flushEventsOnClose) {
        this.flushEventsOnClose = flushEventsOnClose;
        return this;
    }

    public RakamClient trackSessionEvents(boolean trackingSessionEvents) {
        this.trackingSessionEvents = trackingSessionEvents;
        return this;
    }

    void useForegroundTracking() {
        this.usingForegroundTracking = true;
    }

    boolean isUsingForegroundTracking() {
        return this.usingForegroundTracking;
    }

    boolean isInForeground() {
        return this.inForeground;
    }

    public void logEvent(String eventType) {
        this.logEvent(eventType, null);
    }

    public void logEvent(String eventType, JSONObject eventProperties) {
        this.logEvent(eventType, eventProperties, false);
    }

    public void logEvent(String eventType, JSONObject eventProperties, boolean outOfSession) {
        if (this.validateLogEvent(eventType)) {
            this.logEvent(eventType, eventProperties, this.getCurrentTimeMillis(), outOfSession);
        }
    }

    public void logEventSync(String eventType) {
        this.logEventSync(eventType, null);
    }

    public void logEventSync(String eventType, JSONObject eventProperties) {
        this.logEventSync(eventType, eventProperties, false);
    }

    public void logEventSync(String eventType, JSONObject eventProperties, boolean outOfSession) {
        if (this.validateLogEvent(eventType)) {
            this.logEvent(eventType, eventProperties, this.getCurrentTimeMillis(), outOfSession);
        }
    }

    protected boolean validateLogEvent(String eventType) {
        if (TextUtils.isEmpty((CharSequence)eventType)) {
            logger.e(TAG, "Argument eventType cannot be null or blank in logEvent()");
            return false;
        }
        return this.contextAndApiKeySet("logEvent()");
    }

    protected void logEventAsync(final String eventType, JSONObject properties, final long timestamp, final boolean outOfSession) {
        if (properties != null) {
            properties = Utils.cloneJSONObject(properties);
        }
        final JSONObject copyProperties = properties;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(RakamClient.this.apiKey)) {
                    return;
                }
                RakamClient.this.logEvent(eventType, copyProperties, timestamp, outOfSession);
            }
        });
    }

    protected long logEvent(String eventType, JSONObject eventProperties, long timestamp, boolean outOfSession) {
        boolean loggingSessionEvent;
        logger.d(TAG, "Logged event to Rakam: " + eventType);
        if (this.optOut) {
            return -1L;
        }
        boolean bl = loggingSessionEvent = this.trackingSessionEvents && (eventType.equals(START_SESSION_EVENT) || eventType.equals(END_SESSION_EVENT));
        if (!loggingSessionEvent && !outOfSession) {
            if (!this.inForeground) {
                this.startNewSessionIfNeeded(timestamp);
            } else {
                this.refreshSessionTime(timestamp);
            }
        }
        long result = -1L;
        JSONObject properties = new JSONObject();
        try {
            String next;
            Iterator keys;
            Location location;
            properties.put("_id", (Object)UUID.randomUUID().toString());
            properties.put("_local_id", this.lastEventId);
            properties.put("_time", timestamp);
            properties.put("_user", this.replaceWithJSONNull(this.userId));
            properties.put("_device_id", this.replaceWithJSONNull(this.deviceId));
            properties.put("_session_id", outOfSession ? -1L : this.sessionId);
            if (this.trackingOptions.shouldTrackVersionName()) {
                properties.put("_version_name", this.replaceWithJSONNull(this.deviceInfo.getVersionName()));
            }
            if (this.trackingOptions.shouldTrackOsName()) {
                properties.put("_os_name", this.replaceWithJSONNull(this.deviceInfo.getOsName()));
            }
            if (this.trackingOptions.shouldTrackOsVersion()) {
                properties.put("_os_version", this.replaceWithJSONNull(this.deviceInfo.getOsVersion()));
            }
            if (this.trackingOptions.shouldTrackDeviceBrand()) {
                properties.put("_device_brand", this.replaceWithJSONNull(this.deviceInfo.getBrand()));
            }
            if (this.trackingOptions.shouldTrackDeviceManufacturer()) {
                properties.put("_device_manufacturer", this.replaceWithJSONNull(this.deviceInfo.getManufacturer()));
            }
            if (this.trackingOptions.shouldTrackDeviceModel()) {
                properties.put("_device_model", this.replaceWithJSONNull(this.deviceInfo.getModel()));
            }
            if (this.trackingOptions.shouldTrackCarrier()) {
                properties.put("_carrier", this.replaceWithJSONNull(this.deviceInfo.getCarrier()));
            }
            if (this.trackingOptions.shouldTrackCountry()) {
                properties.put("_country_code", this.replaceWithJSONNull(this.deviceInfo.getCountry()));
            }
            if (this.trackingOptions.shouldTrackLanguage()) {
                properties.put("_language", this.replaceWithJSONNull(this.deviceInfo.getLanguage()));
            }
            if (this.trackingOptions.shouldTrackPlatform()) {
                properties.put("_platform", (Object)this.platform);
            }
            properties.put("_library_name", (Object)"rakam-android");
            properties.put("_library_version", (Object)"2.7.14");
            properties.put("_ip", true);
            if (this.trackingOptions.shouldTrackLatLng() && (location = this.deviceInfo.getMostRecentLocation()) != null) {
                properties.put("_latitude", location.getLatitude());
                properties.put("_longitude", location.getLongitude());
            }
            if (this.trackingOptions.shouldTrackAdid() && this.deviceInfo.getAdvertisingId() != null) {
                properties.put("_android_adid", (Object)this.deviceInfo.getAdvertisingId());
            }
            properties.put("_limit_ad_tracking", this.deviceInfo.isLimitAdTrackingEnabled());
            properties.put("_gps_enabled", this.deviceInfo.isGooglePlayServicesEnabled());
            if (eventProperties != null) {
                keys = eventProperties.keys();
                while (keys.hasNext()) {
                    next = (String)keys.next();
                    properties.put(next, eventProperties.get(next));
                }
            }
            if (this.superProperties != null) {
                keys = this.superProperties.keys();
                while (keys.hasNext()) {
                    next = (String)keys.next();
                    if (eventProperties != null && eventProperties.has(next)) continue;
                    properties.put(next, this.superProperties.get(next));
                }
            }
            JSONObject event = new JSONObject();
            event.put("properties", (Object)this.truncate(properties));
            event.put("collection", this.replaceWithJSONNull(eventType));
            result = this.saveEvent(eventType, event);
        }
        catch (JSONException e) {
            logger.e(TAG, String.format("JSON Serialization of event type %s failed, skipping: %s", eventType, e.toString()));
            Diagnostics.getLogger().logError(String.format("Failed to JSON serialize event type %s", eventType), e);
        }
        return result;
    }

    protected long saveEvent(String eventType, JSONObject event) {
        long totalEventCount;
        String eventString = event.toString();
        if (Utils.isEmptyString(eventString)) {
            logger.e(TAG, String.format("Detected empty event string for event type %s, skipping", eventType));
            return -1L;
        }
        if (eventType.equals("$identify")) {
            this.lastIdentifyId = this.dbHelper.addIdentify(eventString);
            this.setLastIdentifyId(this.lastIdentifyId);
        } else {
            this.lastEventId = this.dbHelper.addEvent(eventString);
            this.setLastEventId(this.lastEventId);
        }
        int numEventsToRemove = Math.min(Math.max(1, this.eventMaxCount / 10), 20);
        if (this.dbHelper.getEventCount() > (long)this.eventMaxCount) {
            this.dbHelper.removeEvents(this.dbHelper.getNthEventId(numEventsToRemove));
        }
        if (this.dbHelper.getIdentifyCount() > (long)this.eventMaxCount) {
            this.dbHelper.removeIdentifys(this.dbHelper.getNthIdentifyId(numEventsToRemove));
        }
        if ((totalEventCount = this.dbHelper.getTotalEventCount()) % (long)this.eventUploadThreshold == 0L && totalEventCount >= (long)this.eventUploadThreshold) {
            this.updateServer();
        } else {
            this.updateServerLater(this.eventUploadPeriodMillis);
        }
        return eventType.equals("$identify") ? this.lastIdentifyId : this.lastEventId;
    }

    private long getLongvalue(String key, long defaultValue) {
        Long value = this.dbHelper.getLongValue(key);
        return value == null ? defaultValue : value;
    }

    void setLastEventTime(long timestamp) {
        this.lastEventTime = timestamp;
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_EVENT_TIME_KEY, timestamp);
    }

    void setLastEventId(long eventId) {
        this.lastEventId = eventId;
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_EVENT_ID_KEY, eventId);
    }

    void setLastIdentifyId(long identifyId) {
        this.lastIdentifyId = identifyId;
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_IDENTIFY_ID_KEY, identifyId);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    void setPreviousSessionId(long timestamp) {
        this.previousSessionId = timestamp;
        this.dbHelper.insertOrReplaceKeyLongValue(PREVIOUS_SESSION_ID_KEY, timestamp);
    }

    public boolean startNewSessionIfNeeded(long timestamp) {
        if (this.inSession()) {
            if (this.isWithinMinTimeBetweenSessions(timestamp)) {
                this.refreshSessionTime(timestamp);
                return false;
            }
            this.startNewSession(timestamp);
            return true;
        }
        if (this.isWithinMinTimeBetweenSessions(timestamp)) {
            if (this.previousSessionId == -1L) {
                this.startNewSession(timestamp);
                return true;
            }
            this.setSessionId(this.previousSessionId);
            this.refreshSessionTime(timestamp);
            return false;
        }
        this.startNewSession(timestamp);
        return true;
    }

    private void startNewSession(long timestamp) {
        if (this.trackingSessionEvents) {
            this.sendSessionEvent(END_SESSION_EVENT);
        }
        this.setSessionId(timestamp);
        this.refreshSessionTime(timestamp);
        if (this.trackingSessionEvents) {
            this.sendSessionEvent(START_SESSION_EVENT);
        }
    }

    private boolean inSession() {
        return this.sessionId >= 0L;
    }

    private boolean isWithinMinTimeBetweenSessions(long timestamp) {
        long sessionLimit = this.usingForegroundTracking ? this.minTimeBetweenSessionsMillis : this.sessionTimeoutMillis;
        return timestamp - this.lastEventTime < sessionLimit;
    }

    private void setSessionId(long timestamp) {
        this.sessionId = timestamp;
        this.setPreviousSessionId(timestamp);
    }

    void refreshSessionTime(long timestamp) {
        if (!this.inSession()) {
            return;
        }
        this.setLastEventTime(timestamp);
    }

    private void sendSessionEvent(String sessionEvent) {
        if (!this.contextAndApiKeySet(String.format("sendSessionEvent('%s')", sessionEvent))) {
            return;
        }
        if (!this.inSession()) {
            return;
        }
        this.logEvent(sessionEvent, null, this.lastEventTime, false);
    }

    void onExitForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(RakamClient.this.apiKey)) {
                    return;
                }
                RakamClient.this.refreshSessionTime(timestamp);
                RakamClient.this.inForeground = false;
                if (RakamClient.this.flushEventsOnClose) {
                    RakamClient.this.updateServer();
                }
                RakamClient.this.dbHelper.insertOrReplaceKeyValue(RakamClient.DEVICE_ID_KEY, RakamClient.this.deviceId);
                RakamClient.this.dbHelper.insertOrReplaceKeyValue(RakamClient.USER_ID_KEY, RakamClient.this.userId);
                RakamClient.this.dbHelper.insertOrReplaceKeyLongValue(RakamClient.OPT_OUT_KEY, RakamClient.this.optOut ? 1L : 0L);
                RakamClient.this.dbHelper.insertOrReplaceKeyLongValue(RakamClient.PREVIOUS_SESSION_ID_KEY, RakamClient.this.sessionId);
                RakamClient.this.dbHelper.insertOrReplaceKeyLongValue(RakamClient.LAST_EVENT_TIME_KEY, RakamClient.this.lastEventTime);
            }
        });
    }

    void onEnterForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(RakamClient.this.apiKey)) {
                    return;
                }
                RakamClient.this.startNewSessionIfNeeded(timestamp);
                RakamClient.this.inForeground = true;
            }
        });
    }

    public void logRevenue(Revenue revenue) {
        if (!this.contextAndApiKeySet("logRevenue()") || revenue == null || !revenue.isValidRevenue()) {
            return;
        }
        this.logEvent("_revenue", revenue.toJSONObject());
    }

    public void setUserProperties(JSONObject userProperties, boolean replace) {
        this.setUserProperties(userProperties);
    }

    public void setUserProperties(JSONObject userProperties) {
        if (userProperties == null || userProperties.length() == 0 || !this.contextAndApiKeySet("setUserProperties")) {
            return;
        }
        JSONObject sanitized = this.truncate(userProperties);
        if (sanitized.length() == 0) {
            return;
        }
        Identify identify = new Identify();
        Iterator keys = sanitized.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                identify.setUserProperty(key, sanitized.get(key));
            }
            catch (JSONException e) {
                logger.e(TAG, e.toString());
                Diagnostics.getLogger().logError(String.format("Failed to set user property %s", key), e);
            }
        }
        this.identify(identify);
    }

    public void clearUserProperties() {
        Identify identify = new Identify().clearAll();
        this.identify(identify);
    }

    public void clearSuperProperties() {
        this.dbHelper.insertOrReplaceKeyValue(SUPER_PROPERTIES_KEY, null);
        this.superProperties = null;
    }

    public void identify(Identify identify) {
        this.identify(identify, false);
    }

    public void identify(Identify identify, boolean outOfSession) {
        if (identify == null || identify.userPropertiesOperations.length() == 0 || !this.contextAndApiKeySet("identify()")) {
            return;
        }
        this.logEventAsync("$identify", identify.userPropertiesOperations, this.getCurrentTimeMillis(), outOfSession);
    }

    public JSONObject truncate(JSONObject object) {
        if (object == null) {
            return new JSONObject();
        }
        if (object.length() > 1000) {
            logger.w(TAG, "Warning: too many properties (more than 1000), ignoring");
            return new JSONObject();
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = object.get(key);
                if (value.getClass().equals(String.class)) {
                    object.put(key, (Object)RakamClient.truncate((String)value));
                    continue;
                }
                if (value.getClass().equals(JSONObject.class)) {
                    object.put(key, (Object)this.truncate((JSONObject)value));
                    continue;
                }
                if (!value.getClass().equals(JSONArray.class)) continue;
                object.put(key, (Object)this.truncate((JSONArray)value));
            }
            catch (JSONException e) {
                logger.e(TAG, e.toString());
            }
        }
        return object;
    }

    public JSONArray truncate(JSONArray array) throws JSONException {
        if (array == null) {
            return new JSONArray();
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value.getClass().equals(String.class)) {
                array.put(i, (Object)RakamClient.truncate((String)value));
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                array.put(i, (Object)this.truncate((JSONObject)value));
                continue;
            }
            if (!value.getClass().equals(JSONArray.class)) continue;
            array.put(i, (Object)this.truncate((JSONArray)value));
        }
        return array;
    }

    static String truncate(String value) {
        return value.length() <= 1024 ? value : value.substring(0, 1024);
    }

    public Object getUserId() {
        return this.userId;
    }

    public RakamClient setUserId(String userId) {
        return this.setUserId(userId, false);
    }

    public RakamClient setUserId(final String userId, final boolean startNewSession) {
        if (!this.contextAndApiKeySet("setUserId()")) {
            return this;
        }
        final RakamClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(client.apiKey)) {
                    return;
                }
                if (startNewSession && RakamClient.this.trackingSessionEvents) {
                    RakamClient.this.sendSessionEvent(RakamClient.END_SESSION_EVENT);
                }
                client.userId = userId;
                RakamClient.this.dbHelper.insertOrReplaceKeyValue(RakamClient.USER_ID_KEY, userId);
                if (startNewSession) {
                    long timestamp = RakamClient.this.getCurrentTimeMillis();
                    RakamClient.this.setSessionId(timestamp);
                    RakamClient.this.refreshSessionTime(timestamp);
                    if (RakamClient.this.trackingSessionEvents) {
                        RakamClient.this.sendSessionEvent(RakamClient.START_SESSION_EVENT);
                    }
                }
            }
        });
        return this;
    }

    public RakamClient setUserId(int userId) {
        return this.setUserId(String.valueOf(userId));
    }

    public RakamClient setDeviceId(final String deviceId) {
        Set<String> invalidDeviceIds = this.getInvalidDeviceIds();
        if (!this.contextAndApiKeySet("setDeviceId()") || Utils.isEmptyString(deviceId) || invalidDeviceIds.contains(deviceId)) {
            return this;
        }
        final RakamClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(client.apiKey)) {
                    return;
                }
                client.deviceId = deviceId;
                RakamClient.this.saveDeviceId(deviceId);
            }
        });
        return this;
    }

    public RakamClient regenerateDeviceId() {
        if (!this.contextAndApiKeySet("regenerateDeviceId()")) {
            return this;
        }
        final RakamClient client = this;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(client.apiKey)) {
                    return;
                }
                String randomId = DeviceInfo.generateUUID() + "R";
                RakamClient.this.setDeviceId(randomId);
            }
        });
        return this;
    }

    public void uploadEvents() {
        if (!this.contextAndApiKeySet("uploadEvents()")) {
            return;
        }
        this.logThread.post(new Runnable(){

            @Override
            public void run() {
                if (Utils.isEmptyString(RakamClient.this.apiKey)) {
                    return;
                }
                RakamClient.this.updateServer();
            }
        });
    }

    private void updateServerLater(long delayMillis) {
        if (this.updateScheduled.getAndSet(true)) {
            return;
        }
        this.logThread.postDelayed(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.updateScheduled.set(false);
                RakamClient.this.updateServer();
            }
        }, delayMillis);
    }

    protected void updateServer() {
        this.updateServer(false);
        Diagnostics.getLogger().flushEvents();
    }

    protected void updateServer(boolean limit) {
        if (this.optOut || this.offline) {
            return;
        }
        if (!this.uploadingCurrently.getAndSet(true)) {
            long totalEventCount;
            long batchSize = Math.min(limit ? (long)this.backoffUploadBatchSize : (long)this.eventUploadMaxBatchSize, totalEventCount = this.dbHelper.getTotalEventCount());
            if (batchSize <= 0L) {
                this.uploadingCurrently.set(false);
                return;
            }
            try {
                String body;
                List<JSONObject> events = this.dbHelper.getEvents(this.lastEventId, batchSize);
                List<JSONObject> identifys = this.dbHelper.getIdentifys(this.lastIdentifyId, batchSize);
                Pair<Pair<Long, Long>, JSONArray> merged = this.mergeEventsAndIdentifys(events, identifys, batchSize);
                JSONArray mergedEvents = (JSONArray)merged.second;
                if (mergedEvents.length() == 0) {
                    this.uploadingCurrently.set(false);
                    return;
                }
                final long maxEventId = (Long)((Pair)merged.first).first;
                final long maxIdentifyId = (Long)((Pair)merged.first).second;
                try {
                    body = new JSONObject().put("api", (Object)this.getApi()).put("events", merged.second).toString();
                }
                catch (JSONException e) {
                    this.uploadingCurrently.set(false);
                    logger.e(TAG, e.toString());
                    return;
                }
                this.httpThread.post(new Runnable(){

                    @Override
                    public void run() {
                        RakamClient.this.makeEventUploadPostRequest(RakamClient.this.httpClient, body, maxEventId, maxIdentifyId);
                    }
                });
            }
            catch (JSONException e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, e.toString());
                Diagnostics.getLogger().logError("Failed to update server", e);
            }
            catch (CursorWindowAllocationException e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, String.format("Caught Cursor window exception during event upload, deferring upload: %s", e.getMessage()));
                Diagnostics.getLogger().logError("Failed to update server", e);
            }
        }
    }

    protected Pair<Pair<Long, Long>, JSONArray> mergeEventsAndIdentifys(List<JSONObject> events, List<JSONObject> identifys, long numEvents) throws JSONException {
        JSONArray merged = new JSONArray();
        long maxEventId = -1L;
        long maxIdentifyId = -1L;
        while ((long)merged.length() < numEvents) {
            JSONObject identify;
            JSONObject event;
            boolean noEvents = events.isEmpty();
            boolean noIdentifys = identifys.isEmpty();
            if (noEvents && noIdentifys) {
                logger.w(TAG, String.format("mergeEventsAndIdentifys: number of events and identifys less than expected by %d", numEvents - (long)merged.length()));
                break;
            }
            if (noIdentifys) {
                event = events.remove(0);
                maxEventId = event.getLong("event_id");
                merged.put((Object)event);
                continue;
            }
            if (noEvents) {
                identify = identifys.remove(0);
                maxIdentifyId = identify.getLong("event_id");
                merged.put((Object)identify);
                continue;
            }
            if (!events.get(0).has("event_id") || events.get(0).getLong("event_id") < identifys.get(0).getLong("event_id")) {
                event = events.remove(0);
                maxEventId = event.getLong("event_id");
                merged.put((Object)event);
                continue;
            }
            identify = identifys.remove(0);
            maxIdentifyId = identify.getLong("event_id");
            merged.put((Object)identify);
        }
        return new Pair((Object)new Pair((Object)maxEventId, (Object)maxIdentifyId), (Object)merged);
    }

    private JSONObject getApi() throws JSONException {
        return new JSONObject().put("api_key", (Object)this.apiKey).put("library", (Object)new JSONObject().put("name", (Object)"rakam-android").put("version", (Object)"2.7.14")).put("upload_time", this.getCurrentTimeMillis());
    }

    protected void makeEventUploadPostRequest(OkHttpClient client, String body, final long maxEventId, final long maxIdentifyId) {
        Request request;
        try {
            request = new Request.Builder().url(this.apiUrl + "/event/batch").post(RequestBody.create((MediaType)JSON, (String)body)).build();
        }
        catch (IllegalArgumentException e) {
            logger.e(TAG, e.toString());
            this.uploadingCurrently.set(false);
            Diagnostics.getLogger().logError("Failed to build upload request", e);
            return;
        }
        boolean uploadSuccess = false;
        try {
            Response response = client.newCall(request).execute();
            String stringResponse = response.body().string();
            if (stringResponse.equals("1")) {
                uploadSuccess = true;
                this.logThread.post(new Runnable(){

                    @Override
                    public void run() {
                        if (maxEventId >= 0L) {
                            RakamClient.this.dbHelper.removeEvents(maxEventId);
                        }
                        if (maxIdentifyId >= 0L) {
                            RakamClient.this.dbHelper.removeIdentifys(maxIdentifyId);
                        }
                        RakamClient.this.uploadingCurrently.set(false);
                        if (RakamClient.this.dbHelper.getTotalEventCount() > (long)RakamClient.this.eventUploadThreshold) {
                            RakamClient.this.logThread.post(new Runnable(){

                                @Override
                                public void run() {
                                    RakamClient.this.updateServer(RakamClient.this.backoffUpload);
                                }
                            });
                        } else {
                            RakamClient.this.backoffUpload = false;
                            RakamClient.this.backoffUploadBatchSize = RakamClient.this.eventUploadMaxBatchSize;
                        }
                    }
                });
            } else if (response.code() == 403) {
                logger.e(TAG, "Invalid API key, make sure your API key is correct in initialize()");
            } else if (stringResponse.equals("bad_checksum")) {
                logger.w(TAG, "Bad checksum, post request was mangled in transit, will attempt to reupload later");
            } else if (stringResponse.equals("request_db_write_failed")) {
                logger.w(TAG, "Couldn't write to request database on server, will attempt to reupload later");
            } else if (response.code() == 413 || response.code() == 400) {
                if (this.backoffUpload && this.backoffUploadBatchSize == 1) {
                    if (maxEventId >= 0L) {
                        this.dbHelper.removeEvent(maxEventId);
                    }
                    if (maxIdentifyId >= 0L) {
                        this.dbHelper.removeIdentify(maxIdentifyId);
                    }
                }
                this.backoffUpload = true;
                int numEvents = Math.min((int)this.dbHelper.getEventCount(), this.backoffUploadBatchSize);
                this.backoffUploadBatchSize = (int)Math.ceil((double)numEvents / 2.0);
                logger.w(TAG, String.format("Request too large or invalid: %s, will decrease size and attempt to reupload", response.code()));
                this.logThread.post(new Runnable(){

                    @Override
                    public void run() {
                        RakamClient.this.uploadingCurrently.set(false);
                        RakamClient.this.updateServer(true);
                    }
                });
            } else if (response.code() == 500) {
                logger.w(TAG, "A server error occurred, will attempt to reupload later");
            } else {
                logger.w(TAG, "Upload failed, " + stringResponse + ", will attempt to reupload later");
            }
        }
        catch (ConnectException e) {
            this.lastError = e;
            Diagnostics.getLogger().logError("Failed to post upload request", e);
        }
        catch (UnknownHostException e) {
            this.lastError = e;
            Diagnostics.getLogger().logError("Failed to post upload request", e);
        }
        catch (IOException e) {
            logger.e(TAG, e.toString());
            this.lastError = e;
            Diagnostics.getLogger().logError("Failed to post upload request", e);
        }
        catch (AssertionError e) {
            logger.e(TAG, "Exception:", (Throwable)((Object)e));
            this.lastError = e;
            Diagnostics.getLogger().logError("Failed to post upload request", (Throwable)((Object)e));
        }
        catch (Exception e) {
            logger.e(TAG, "Exception:", e);
            this.lastError = e;
            Diagnostics.getLogger().logError("Failed to post upload request", e);
        }
        if (!uploadSuccess) {
            this.uploadingCurrently.set(false);
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private Set<String> getInvalidDeviceIds() {
        HashSet<String> invalidDeviceIds = new HashSet<String>();
        invalidDeviceIds.add("");
        invalidDeviceIds.add("9774d56d682e549c");
        invalidDeviceIds.add("unknown");
        invalidDeviceIds.add("000000000000000");
        invalidDeviceIds.add("00000000-0000-0000-0000-000000000000");
        invalidDeviceIds.add("Android");
        invalidDeviceIds.add("DEFACE");
        return invalidDeviceIds;
    }

    private String initializeDeviceId() {
        String advertisingId;
        Set<String> invalidIds = this.getInvalidDeviceIds();
        String deviceId = this.dbHelper.getValue(DEVICE_ID_KEY);
        String sharedPrefDeviceId = Utils.getStringFromSharedPreferences(this.context, this.instanceName, DEVICE_ID_KEY);
        if (!Utils.isEmptyString(deviceId) && !invalidIds.contains(deviceId)) {
            if (!deviceId.equals(sharedPrefDeviceId)) {
                this.saveDeviceId(deviceId);
            }
            return deviceId;
        }
        if (!Utils.isEmptyString(sharedPrefDeviceId) && !invalidIds.contains(sharedPrefDeviceId)) {
            this.saveDeviceId(sharedPrefDeviceId);
            return sharedPrefDeviceId;
        }
        if (!(this.newDeviceIdPerInstall || !this.useAdvertisingIdForDeviceId || this.deviceInfo.isLimitAdTrackingEnabled() || Utils.isEmptyString(advertisingId = this.deviceInfo.getAdvertisingId()) || invalidIds.contains(advertisingId))) {
            this.saveDeviceId(advertisingId);
            return advertisingId;
        }
        RakamClient rakamClient = this;
        String randomId = rakamClient.deviceInfo.generateUUID() + "R";
        this.saveDeviceId(randomId);
        return randomId;
    }

    private void saveDeviceId(String deviceId) {
        this.dbHelper.insertOrReplaceKeyValue(DEVICE_ID_KEY, deviceId);
        Utils.writeStringToSharedPreferences(this.context, this.instanceName, DEVICE_ID_KEY, deviceId);
    }

    private void runOnLogThread(Runnable r) {
        if (Thread.currentThread() != this.logThread) {
            this.logThread.post(r);
        } else {
            r.run();
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(URL apiUrl) {
        if (apiUrl == null) {
            logger.e(TAG, "apiUrl can't be null");
            return;
        }
        String scheme = apiUrl.getProtocol();
        String serverName = apiUrl.getHost();
        int serverPort = apiUrl.getPort();
        String address = scheme + "://" + serverName;
        if (apiUrl.getPath() != null && !apiUrl.getPath().equals("/") && !apiUrl.getPath().isEmpty()) {
            throw new IllegalStateException(String.format("Please set root address of the API address. A valid example is %s, %s is not valid.", address, apiUrl.toString()));
        }
        if (serverPort > -1) {
            address = address + ":" + serverPort;
        }
        this.apiUrl = address;
    }

    protected Object replaceWithJSONNull(Object obj) {
        return obj == null ? JSONObject.NULL : obj;
    }

    protected synchronized boolean contextAndApiKeySet(String methodName) {
        if (this.context == null) {
            logger.e(TAG, "context cannot be null, set context with initialize() before calling " + methodName);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
            logger.e(TAG, "apiKey cannot be null or empty, set apiKey with initialize() before calling " + methodName);
            return false;
        }
        return true;
    }

    protected String bytesToHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static boolean upgradePrefs(Context context) {
        return RakamClient.upgradePrefs(context, null, null);
    }

    static boolean upgradePrefs(Context context, String sourcePkgName, String targetPkgName) {
        try {
            if (sourcePkgName == null) {
                sourcePkgName = "io.rakam.api";
                try {
                    sourcePkgName = Constants.class.getPackage().getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (targetPkgName == null) {
                targetPkgName = "io.rakam.api";
            }
            if (targetPkgName.equals(sourcePkgName)) {
                return false;
            }
            String sourcePrefsName = sourcePkgName + "." + context.getPackageName();
            SharedPreferences source = context.getSharedPreferences(sourcePrefsName, 0);
            if (source.getAll().size() == 0) {
                return false;
            }
            String prefsName = targetPkgName + "." + context.getPackageName();
            SharedPreferences targetPrefs = context.getSharedPreferences(prefsName, 0);
            SharedPreferences.Editor target = targetPrefs.edit();
            if (source.contains(sourcePkgName + ".previousSessionId")) {
                target.putLong("io.rakam.api.previousSessionId", source.getLong(sourcePkgName + ".previousSessionId", -1L));
            }
            if (source.contains(sourcePkgName + ".deviceId")) {
                target.putString("io.rakam.api.deviceId", source.getString(sourcePkgName + ".deviceId", null));
            }
            if (source.contains(sourcePkgName + ".userId")) {
                target.putString("io.rakam.api.userId", source.getString(sourcePkgName + ".userId", null));
            }
            if (source.contains(sourcePkgName + ".optOut")) {
                target.putBoolean("io.rakam.api.optOut", source.getBoolean(sourcePkgName + ".optOut", false));
            }
            target.apply();
            source.edit().clear().apply();
            logger.i(TAG, "Upgraded shared preferences from " + sourcePrefsName + " to " + prefsName);
            return true;
        }
        catch (Exception e) {
            logger.e(TAG, "Error upgrading shared preferences", e);
            Diagnostics.getLogger().logError("Failed to upgrade shared prefs", e);
            return false;
        }
    }

    static boolean upgradeSharedPrefsToDB(Context context) {
        return RakamClient.upgradeSharedPrefsToDB(context, null);
    }

    static boolean upgradeSharedPrefsToDB(Context context, String sourcePkgName) {
        if (sourcePkgName == null) {
            sourcePkgName = "io.rakam.api";
        }
        DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(context);
        String deviceId = dbHelper.getValue(DEVICE_ID_KEY);
        Long previousSessionId = dbHelper.getLongValue(PREVIOUS_SESSION_ID_KEY);
        Long lastEventTime = dbHelper.getLongValue(LAST_EVENT_TIME_KEY);
        if (!Utils.isEmptyString(deviceId) && previousSessionId != null && lastEventTime != null) {
            return true;
        }
        String prefsName = sourcePkgName + "." + context.getPackageName();
        SharedPreferences preferences = context.getSharedPreferences(prefsName, 0);
        RakamClient.migrateStringValue(preferences, "io.rakam.api.deviceId", null, dbHelper, DEVICE_ID_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.lastEventTime", -1L, dbHelper, LAST_EVENT_TIME_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.lastEventId", -1L, dbHelper, LAST_EVENT_ID_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.lastIdentifyId", -1L, dbHelper, LAST_IDENTIFY_ID_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.previousSessionId", -1L, dbHelper, PREVIOUS_SESSION_ID_KEY);
        RakamClient.migrateStringValue(preferences, "io.rakam.api.userId", null, dbHelper, USER_ID_KEY);
        RakamClient.migrateBooleanValue(preferences, "io.rakam.api.optOut", false, dbHelper, OPT_OUT_KEY);
        return true;
    }

    private static void migrateLongValue(SharedPreferences prefs, String prefKey, long defValue, DatabaseHelper dbHelper, String dbKey) {
        Long value = dbHelper.getLongValue(dbKey);
        if (value != null) {
            return;
        }
        long oldValue = prefs.getLong(prefKey, defValue);
        dbHelper.insertOrReplaceKeyLongValue(dbKey, oldValue);
        prefs.edit().remove(prefKey).apply();
    }

    private static void migrateStringValue(SharedPreferences prefs, String prefKey, String defValue, DatabaseHelper dbHelper, String dbKey) {
        String value = dbHelper.getValue(dbKey);
        if (!Utils.isEmptyString(value)) {
            return;
        }
        String oldValue = prefs.getString(prefKey, defValue);
        if (!Utils.isEmptyString(oldValue)) {
            dbHelper.insertOrReplaceKeyValue(dbKey, oldValue);
            prefs.edit().remove(prefKey).apply();
        }
    }

    private static void migrateBooleanValue(SharedPreferences prefs, String prefKey, boolean defValue, DatabaseHelper dbHelper, String dbKey) {
        Long value = dbHelper.getLongValue(dbKey);
        if (value != null) {
            return;
        }
        boolean oldValue = prefs.getBoolean(prefKey, defValue);
        dbHelper.insertOrReplaceKeyLongValue(dbKey, oldValue ? 1L : 0L);
        prefs.edit().remove(prefKey).apply();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

