/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import io.rakam.api.RakamClient;
import io.rakam.api.RakamLog;

class RakamCallbacks
implements Application.ActivityLifecycleCallbacks {
    public static final String TAG = "io.rakam.api.RakamCallbacks";
    private static final String NULLMSG = "Need to initialize RakamCallbacks with RakamClient instance";
    private RakamClient clientInstance = null;
    private static RakamLog logger = RakamLog.getLogger();

    public RakamCallbacks(RakamClient clientInstance) {
        if (clientInstance == null) {
            logger.e(TAG, NULLMSG);
            return;
        }
        this.clientInstance = clientInstance;
        clientInstance.useForegroundTracking();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (this.clientInstance == null) {
            logger.e(TAG, NULLMSG);
            return;
        }
        this.clientInstance.onExitForeground(this.getCurrentTimeMillis());
    }

    public void onActivityResumed(Activity activity) {
        if (this.clientInstance == null) {
            logger.e(TAG, NULLMSG);
            return;
        }
        this.clientInstance.onEnterForeground(this.getCurrentTimeMillis());
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outstate) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

