/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.util.Log;
import io.rakam.api.RakamClient;
import io.rakam.api.RakamLog;
import io.rakam.api.Utils;
import io.rakam.api.WorkerThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Diagnostics {
    private static final RakamLog logger = RakamLog.getLogger();
    public static final String TAG = "RakamDiagnostics";
    public static final String DIAGNOSTIC_EVENT_ENDPOINT = "https://diagnostics.rakam.io/event/batch";
    public static final int DIAGNOSTIC_EVENT_MAX_COUNT = 50;
    public static final int DIAGNOSTIC_EVENT_MIN_COUNT = 5;
    volatile boolean enabled = false;
    private volatile String apiKey;
    private volatile OkHttpClient httpClient;
    private volatile String deviceId;
    int diagnosticEventMaxCount = 50;
    String url = "https://diagnostics.rakam.io/event/batch";
    WorkerThread diagnosticThread = new WorkerThread("diagnosticThread");
    List<String> unsentErrorStrings = new ArrayList<String>(this.diagnosticEventMaxCount);
    Map<String, JSONObject> unsentErrors = new HashMap<String, JSONObject>(this.diagnosticEventMaxCount);
    protected static Diagnostics instance;

    static synchronized Diagnostics getLogger() {
        if (instance == null) {
            instance = new Diagnostics();
        }
        return instance;
    }

    private Diagnostics() {
        this.diagnosticThread.start();
    }

    Diagnostics enableLogging(OkHttpClient httpClient, String apiKey, String deviceId) {
        this.enabled = true;
        this.apiKey = apiKey;
        this.httpClient = httpClient;
        this.deviceId = deviceId;
        return this;
    }

    Diagnostics disableLogging() {
        this.enabled = false;
        return this;
    }

    Diagnostics setDiagnosticEventMaxCount(final int diagnosticEventMaxCount) {
        final Diagnostics client = this;
        this.runOnBgThread(new Runnable(){

            @Override
            public void run() {
                client.diagnosticEventMaxCount = Math.max(diagnosticEventMaxCount, 5);
                client.diagnosticEventMaxCount = Math.min(client.diagnosticEventMaxCount, 50);
                if (client.diagnosticEventMaxCount < client.unsentErrorStrings.size()) {
                    for (int i = 0; i < Diagnostics.this.unsentErrorStrings.size() - client.diagnosticEventMaxCount; ++i) {
                        String errorString = Diagnostics.this.unsentErrorStrings.remove(0);
                        Diagnostics.this.unsentErrors.remove(errorString);
                    }
                }
            }
        });
        return this;
    }

    Diagnostics logError(String error) {
        return this.logError(error, null);
    }

    Diagnostics logError(final String error, final Throwable exception) {
        if (!this.enabled || Utils.isEmptyString(error) || Utils.isEmptyString(this.deviceId)) {
            return this;
        }
        this.runOnBgThread(new Runnable(){

            @Override
            public void run() {
                JSONObject event = Diagnostics.this.unsentErrors.get(error);
                if (event == null) {
                    event = new JSONObject();
                    try {
                        String stackTrace;
                        event.put("error", (Object)RakamClient.truncate(error));
                        event.put("timestamp", System.currentTimeMillis());
                        event.put("device_id", (Object)Diagnostics.this.deviceId);
                        event.put("count", 1);
                        if (exception != null && !Utils.isEmptyString(stackTrace = Log.getStackTraceString((Throwable)exception))) {
                            event.put("stack_trace", (Object)RakamClient.truncate(stackTrace));
                        }
                        if (Diagnostics.this.unsentErrorStrings.size() >= Diagnostics.this.diagnosticEventMaxCount) {
                            for (int i = 0; i < 5; ++i) {
                                String errorString = Diagnostics.this.unsentErrorStrings.remove(0);
                                Diagnostics.this.unsentErrors.remove(errorString);
                            }
                        }
                        Diagnostics.this.unsentErrors.put(error, event);
                        Diagnostics.this.unsentErrorStrings.add(error);
                    }
                    catch (JSONException i) {}
                } else {
                    int count = event.optInt("count", 0);
                    try {
                        event.put("count", count + 1);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
        });
        return this;
    }

    Diagnostics flushEvents() {
        if (!this.enabled || Utils.isEmptyString(this.apiKey) || this.httpClient == null || Utils.isEmptyString(this.deviceId)) {
            return this;
        }
        this.runOnBgThread(new Runnable(){

            @Override
            public void run() {
                if (Diagnostics.this.unsentErrorStrings.isEmpty()) {
                    return;
                }
                ArrayList<JSONObject> orderedEvents = new ArrayList<JSONObject>(Diagnostics.this.unsentErrorStrings.size());
                for (String error : Diagnostics.this.unsentErrorStrings) {
                    JSONObject event;
                    try {
                        event = new JSONObject().put("properties", (Object)Diagnostics.this.unsentErrors.get(error)).put("collection", (Object)"android_sdk_error");
                    }
                    catch (JSONException e) {
                        logger.e(Diagnostics.TAG, "Unable to serialize events: " + e.getMessage());
                        continue;
                    }
                    orderedEvents.add(event);
                }
                JSONArray eventJson = new JSONArray(orderedEvents);
                if (eventJson.length() > 0) {
                    Diagnostics.this.makeEventUploadPostRequest(new JSONArray(orderedEvents));
                }
            }
        });
        return this;
    }

    protected void makeEventUploadPostRequest(JSONArray events) {
        String body;
        try {
            JSONObject api = new JSONObject().put("api_key", (Object)this.apiKey).put("library", (Object)new JSONObject().put("name", (Object)"rakam-android").put("version", (Object)"2.7.14")).put("upload_time", System.currentTimeMillis());
            body = new JSONObject().put("api", (Object)api).put("events", (Object)events).toString();
        }
        catch (JSONException e) {
            logger.e(TAG, String.format("Failed to convert revenue object to JSON: %s", e.toString()));
            return;
        }
        Request request = new Request.Builder().url(this.url).post(RequestBody.create((MediaType)RakamClient.JSON, (String)body)).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            String stringResponse = response.body().string();
            if (stringResponse.equals("1")) {
                this.unsentErrors.clear();
                this.unsentErrorStrings.clear();
            }
        }
        catch (IOException iOException) {
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void runOnBgThread(Runnable r) {
        if (Thread.currentThread() != this.diagnosticThread) {
            this.diagnosticThread.post(r);
        } else {
            r.run();
        }
    }
}

