/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.util.Log;

public class RakamLog {
    private volatile boolean enableLogging = true;
    private volatile int logLevel = 4;
    protected static RakamLog instance = new RakamLog();

    public static RakamLog getLogger() {
        return instance;
    }

    private RakamLog() {
    }

    RakamLog setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
        return instance;
    }

    RakamLog setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        return instance;
    }

    int d(String tag, String msg) {
        if (this.enableLogging && this.logLevel <= 3) {
            return Log.d((String)tag, (String)msg);
        }
        return 0;
    }

    int d(String tag, String msg, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 3) {
            return Log.d((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    int e(String tag, String msg) {
        if (this.enableLogging && this.logLevel <= 6) {
            return Log.e((String)tag, (String)msg);
        }
        return 0;
    }

    int e(String tag, String msg, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 6) {
            return Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    String getStackTraceString(Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }

    int i(String tag, String msg) {
        if (this.enableLogging && this.logLevel <= 4) {
            return Log.i((String)tag, (String)msg);
        }
        return 0;
    }

    int i(String tag, String msg, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 4) {
            return Log.i((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    boolean isLoggable(String tag, int level) {
        return Log.isLoggable((String)tag, (int)level);
    }

    int println(int priority, String tag, String msg) {
        return Log.println((int)priority, (String)tag, (String)msg);
    }

    int v(String tag, String msg) {
        if (this.enableLogging && this.logLevel <= 2) {
            return Log.v((String)tag, (String)msg);
        }
        return 0;
    }

    int v(String tag, String msg, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 2) {
            return Log.v((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    int w(String tag, String msg) {
        if (this.enableLogging && this.logLevel <= 5) {
            return Log.w((String)tag, (String)msg);
        }
        return 0;
    }

    int w(String tag, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 5) {
            return Log.w((String)tag, (Throwable)tr);
        }
        return 0;
    }

    int w(String tag, String msg, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 5) {
            return Log.w((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }

    int wtf(String tag, String msg) {
        if (this.enableLogging && this.logLevel <= 7) {
            return Log.wtf((String)tag, (String)msg);
        }
        return 0;
    }

    int wtf(String tag, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 7) {
            return Log.wtf((String)tag, (Throwable)tr);
        }
        return 0;
    }

    int wtf(String tag, String msg, Throwable tr) {
        if (this.enableLogging && this.logLevel <= 7) {
            return Log.wtf((String)tag, (String)msg, (Throwable)tr);
        }
        return 0;
    }
}

