/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.os.Build;
import android.text.TextUtils;
import io.rakam.api.Constants;
import io.rakam.api.CursorWindowAllocationException;
import io.rakam.api.DatabaseHelper;
import io.rakam.api.DeviceInfo;
import io.rakam.api.Identify;
import io.rakam.api.RakamCallbacks;
import io.rakam.api.RakamLog;
import io.rakam.api.Revenue;
import io.rakam.api.Utils;
import io.rakam.api.WorkerThread;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RakamClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String TAG = "RakamClient";
    public static final String START_SESSION_EVENT = "_session_start";
    public static final String END_SESSION_EVENT = "_session_end";
    public static final String DEVICE_ID_KEY = "device_id";
    public static final String USER_ID_KEY = "user_id";
    public static final String SUPER_PROPERTIES_KEY = "super_properties";
    public static final String OPT_OUT_KEY = "opt_out";
    public static final String LAST_EVENT_TIME_KEY = "last_event_time";
    public static final String LAST_EVENT_ID_KEY = "last_event_id";
    public static final String LAST_IDENTIFY_ID_KEY = "last_identify_id";
    public static final String PREVIOUS_SESSION_ID_KEY = "previous_session_id";
    protected static RakamClient instance = new RakamClient();
    private String apiUrl;
    private static final RakamLog logger = RakamLog.getLogger();
    protected Context context;
    protected OkHttpClient httpClient;
    protected DatabaseHelper dbHelper;
    protected String apiKey;
    protected Object userId;
    protected String deviceId;
    private boolean useAdvertisingIdForDeviceId = false;
    private boolean initialized = false;
    private boolean optOut = false;
    private boolean offline = false;
    private DeviceInfo deviceInfo;
    long sessionId = -1L;
    private int eventUploadThreshold = 30;
    private int eventUploadMaxBatchSize = 100;
    private int eventMaxCount = 1000;
    private long eventUploadPeriodMillis = 30000L;
    private long minTimeBetweenSessionsMillis = 300000L;
    private long sessionTimeoutMillis = 1800000L;
    private boolean backoffUpload = false;
    private int backoffUploadBatchSize = this.eventUploadMaxBatchSize;
    private boolean usingForegroundTracking = false;
    private boolean trackingSessionEvents = false;
    private boolean inForeground = false;
    private JSONObject superProperties;
    private AtomicBoolean updateScheduled = new AtomicBoolean(false);
    AtomicBoolean uploadingCurrently = new AtomicBoolean(false);
    Throwable lastError;
    WorkerThread logThread = new WorkerThread("logThread");
    WorkerThread httpThread = new WorkerThread("httpThread");

    public static RakamClient getInstance() {
        return instance;
    }

    public RakamClient() {
        this.logThread.start();
        this.httpThread.start();
        this.logThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.e(RakamClient.TAG, "Unknown exception thrown from log thread.", e);
            }
        });
        this.httpThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.e(RakamClient.TAG, "Unknown exception thrown from HTTP thread.", e);
            }
        });
    }

    public RakamClient initialize(Context context, URL apiUrl, String apiKey) {
        return this.initialize(context, apiUrl, apiKey, null);
    }

    public RakamClient setSuperProperties(JSONObject superProperties) {
        this.superProperties = superProperties;
        this.dbHelper.insertOrReplaceKeyValue(SUPER_PROPERTIES_KEY, superProperties.toString());
        return this;
    }

    public JSONObject getSuperProperties() {
        return Utils.cloneJSONObject(this.superProperties);
    }

    public synchronized RakamClient initialize(Context context, URL apiUrl, String apiKey, String userId) {
        if (context == null) {
            logger.e(TAG, "Argument context cannot be null in initialize()");
            return this;
        }
        RakamClient.upgradePrefs(context);
        if (!RakamClient.upgradeSharedPrefsToDB(context)) {
            return this;
        }
        this.setApiUrl(apiUrl);
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            logger.e(TAG, "Argument apiKey cannot be null or blank in initialize()");
            return this;
        }
        if (!this.initialized) {
            this.context = context.getApplicationContext();
            this.httpClient = new OkHttpClient();
            this.dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
            this.apiKey = apiKey;
            this.initializeDeviceInfo();
            try {
                if (userId != null) {
                    this.userId = userId;
                    this.dbHelper.insertOrReplaceKeyValue(USER_ID_KEY, userId);
                } else {
                    this.userId = this.dbHelper.getValue(USER_ID_KEY);
                }
                Long optOut = this.dbHelper.getLongValue(OPT_OUT_KEY);
                this.optOut = optOut != null && optOut == 1L;
                long previousSessionId = this.getPreviousSessionId();
                if (previousSessionId >= 0L) {
                    this.sessionId = previousSessionId;
                }
                this.initialized = true;
                String value = this.dbHelper.getValue(SUPER_PROPERTIES_KEY);
                if (value != null) {
                    try {
                        this.superProperties = new JSONObject(value);
                    }
                    catch (JSONException e) {
                        this.dbHelper.insertOrReplaceKeyValue(SUPER_PROPERTIES_KEY, null);
                    }
                }
            }
            catch (CursorWindowAllocationException e) {
                logger.e(TAG, String.format("Failed to initialize Rakam SDK due to: %s", e.getMessage()));
                this.apiKey = null;
                this.apiUrl = null;
            }
        }
        return this;
    }

    public RakamClient enableForegroundTracking(Application app) {
        if (this.usingForegroundTracking || !this.contextAndApiKeySet("enableForegroundTracking()")) {
            return this;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new RakamCallbacks(this));
        }
        return this;
    }

    private void initializeDeviceInfo() {
        this.deviceInfo = new DeviceInfo(this.context);
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.deviceId = RakamClient.this.initializeDeviceId();
                RakamClient.this.deviceInfo.prefetch();
            }
        });
    }

    public RakamClient useAdvertisingIdForDeviceId() {
        this.useAdvertisingIdForDeviceId = true;
        return this;
    }

    public RakamClient enableLocationListening() {
        if (this.deviceInfo == null) {
            throw new IllegalStateException("Must initialize before acting on location listening.");
        }
        this.deviceInfo.setLocationListening(true);
        return this;
    }

    public RakamClient disableLocationListening() {
        if (this.deviceInfo == null) {
            throw new IllegalStateException("Must initialize before acting on location listening.");
        }
        this.deviceInfo.setLocationListening(false);
        return this;
    }

    public RakamClient setEventUploadThreshold(int eventUploadThreshold) {
        this.eventUploadThreshold = eventUploadThreshold;
        return this;
    }

    public RakamClient setEventUploadMaxBatchSize(int eventUploadMaxBatchSize) {
        this.eventUploadMaxBatchSize = eventUploadMaxBatchSize;
        this.backoffUploadBatchSize = eventUploadMaxBatchSize;
        return this;
    }

    public RakamClient setEventMaxCount(int eventMaxCount) {
        this.eventMaxCount = eventMaxCount;
        return this;
    }

    public RakamClient setEventUploadPeriodMillis(int eventUploadPeriodMillis) {
        this.eventUploadPeriodMillis = eventUploadPeriodMillis;
        return this;
    }

    public RakamClient setMinTimeBetweenSessionsMillis(long minTimeBetweenSessionsMillis) {
        this.minTimeBetweenSessionsMillis = minTimeBetweenSessionsMillis;
        return this;
    }

    public RakamClient setSessionTimeoutMillis(long sessionTimeoutMillis) {
        this.sessionTimeoutMillis = sessionTimeoutMillis;
        return this;
    }

    public RakamClient setOptOut(boolean optOut) {
        if (!this.contextAndApiKeySet("setOptOut()")) {
            return this;
        }
        this.optOut = optOut;
        this.dbHelper.insertOrReplaceKeyLongValue(OPT_OUT_KEY, optOut ? 1L : 0L);
        return this;
    }

    public boolean isOptedOut() {
        return this.optOut;
    }

    public RakamClient enableLogging(boolean enableLogging) {
        logger.setEnableLogging(enableLogging);
        return this;
    }

    public RakamClient setLogLevel(int logLevel) {
        logger.setLogLevel(logLevel);
        return this;
    }

    public RakamClient setOffline(boolean offline) {
        this.offline = offline;
        if (!offline) {
            this.uploadEvents();
        }
        return this;
    }

    public RakamClient trackSessionEvents(boolean trackingSessionEvents) {
        this.trackingSessionEvents = trackingSessionEvents;
        return this;
    }

    void useForegroundTracking() {
        this.usingForegroundTracking = true;
    }

    boolean isUsingForegroundTracking() {
        return this.usingForegroundTracking;
    }

    boolean isInForeground() {
        return this.inForeground;
    }

    public void logEvent(String eventType) {
        this.logEvent(eventType, null);
    }

    public void logEvent(String eventType, JSONObject eventProperties) {
        if (eventType == null) {
            logger.w(TAG, "Collection name can't be null, ignoring event");
            return;
        }
        if (eventType.isEmpty()) {
            logger.w(TAG, "Collection name can't be an empty string, ignoring event");
            return;
        }
        this.logEvent(eventType, eventProperties, this.getCurrentTimeMillis(), false);
    }

    public void logEvent(String eventType, JSONObject eventProperties, boolean outOfSession) {
        this.logEvent(eventType, eventProperties, this.getCurrentTimeMillis(), outOfSession);
    }

    public void logEventSync(String eventType) {
        this.logEventSync(eventType, null);
    }

    public void logEventSync(String eventType, JSONObject eventProperties) {
        this.logEventSync(eventType, eventProperties, false);
    }

    public void logEventSync(String eventType, JSONObject eventProperties, boolean outOfSession) {
        this.logEvent(eventType, eventProperties, this.getCurrentTimeMillis(), outOfSession);
    }

    protected boolean validateLogEvent(String eventType) {
        if (TextUtils.isEmpty((CharSequence)eventType)) {
            logger.e(TAG, "Argument eventType cannot be null or blank in logEvent()");
            return false;
        }
        return this.contextAndApiKeySet("logEvent()");
    }

    protected void logEventAsync(final String eventType, JSONObject properties, final long timestamp, final boolean outOfSession) {
        if (properties != null) {
            properties = Utils.cloneJSONObject(properties);
        }
        final JSONObject copyProperties = properties;
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.logEvent(eventType, copyProperties, timestamp, outOfSession);
            }
        });
    }

    protected long logEvent(String eventType, JSONObject eventProperties, long timestamp, boolean outOfSession) {
        boolean loggingSessionEvent;
        logger.d(TAG, "Logged event to Rakam: " + eventType);
        if (this.optOut) {
            return -1L;
        }
        boolean bl = loggingSessionEvent = this.trackingSessionEvents && (eventType.equals(START_SESSION_EVENT) || eventType.equals(END_SESSION_EVENT));
        if (!loggingSessionEvent && !outOfSession) {
            if (!this.inForeground) {
                this.startNewSessionIfNeeded(timestamp);
            } else {
                this.refreshSessionTime(timestamp);
            }
        }
        JSONObject event = new JSONObject();
        try {
            String next;
            Iterator keys;
            JSONObject properties = new JSONObject();
            properties.put("_id", (Object)UUID.randomUUID().toString());
            properties.put("_local_id", this.getLastEventId() + 1L);
            properties.put("_time", timestamp);
            properties.put("_user", this.replaceWithJSONNull(this.userId));
            properties.put("_device_id", this.replaceWithJSONNull(this.deviceId));
            properties.put("_session_id", outOfSession ? -1L : this.sessionId);
            properties.put("_version_name", this.replaceWithJSONNull(this.deviceInfo.getVersionName()));
            properties.put("_os_name", this.replaceWithJSONNull(this.deviceInfo.getOsName()));
            properties.put("_os_version", this.replaceWithJSONNull(this.deviceInfo.getOsVersion()));
            properties.put("_device_brand", this.replaceWithJSONNull(this.deviceInfo.getBrand()));
            properties.put("_device_manufacturer", this.replaceWithJSONNull(this.deviceInfo.getManufacturer()));
            properties.put("_device_model", this.replaceWithJSONNull(this.deviceInfo.getModel()));
            properties.put("_carrier", this.replaceWithJSONNull(this.deviceInfo.getCarrier()));
            properties.put("_country_code", this.replaceWithJSONNull(this.deviceInfo.getCountry()));
            properties.put("_language", this.replaceWithJSONNull(this.deviceInfo.getLanguage()));
            properties.put("_platform", (Object)"Android");
            properties.put("_library_name", (Object)"rakam-android");
            properties.put("_library_version", (Object)"2.7.4");
            properties.put("_ip", true);
            Location location = this.deviceInfo.getMostRecentLocation();
            if (location != null) {
                properties.put("_latitude", location.getLatitude());
                properties.put("_longitude", location.getLongitude());
            }
            if (this.deviceInfo.getAdvertisingId() != null) {
                properties.put("_android_adid", (Object)this.deviceInfo.getAdvertisingId());
            }
            properties.put("_limit_ad_tracking", this.deviceInfo.isLimitAdTrackingEnabled());
            properties.put("_gps_enabled", this.deviceInfo.isGooglePlayServicesEnabled());
            if (eventProperties != null) {
                keys = eventProperties.keys();
                while (keys.hasNext()) {
                    next = (String)keys.next();
                    properties.put(next, eventProperties.get(next));
                }
            }
            if (this.superProperties != null) {
                keys = this.superProperties.keys();
                while (keys.hasNext()) {
                    next = (String)keys.next();
                    if (eventProperties != null && eventProperties.has(next)) continue;
                    properties.put(next, this.superProperties.get(next));
                }
            }
            event.put("properties", (Object)this.truncate(properties));
            event.put("collection", this.replaceWithJSONNull(eventType));
        }
        catch (JSONException e) {
            logger.e(TAG, e.toString());
        }
        return this.recordAction(event);
    }

    protected long recordAction(JSONObject event) {
        long totalEventCount;
        long eventId = this.dbHelper.addEvent(event.toString());
        this.setLastEventId(eventId);
        int numEventsToRemove = Math.min(Math.max(1, this.eventMaxCount / 10), 20);
        if (this.dbHelper.getEventCount() > (long)this.eventMaxCount) {
            this.dbHelper.removeEvents(this.dbHelper.getNthEventId(numEventsToRemove));
        }
        if ((totalEventCount = this.dbHelper.getEventCount()) % (long)this.eventUploadThreshold == 0L && totalEventCount >= (long)this.eventUploadThreshold) {
            this.syncEventsWithServer();
        } else {
            this.syncServerLater(this.eventUploadPeriodMillis);
        }
        return eventId;
    }

    private long getLongvalue(String key, long defaultValue) {
        Long value = this.dbHelper.getLongValue(key);
        return value == null ? defaultValue : value;
    }

    long getLastEventTime() {
        return this.getLongvalue(LAST_EVENT_TIME_KEY, -1L);
    }

    void setLastEventTime(long timestamp) {
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_EVENT_TIME_KEY, timestamp);
    }

    long getLastEventId() {
        return this.getLongvalue(LAST_EVENT_ID_KEY, -1L);
    }

    void setLastEventId(long eventId) {
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_EVENT_ID_KEY, eventId);
    }

    long getLastIdentifyId() {
        return this.getLongvalue(LAST_IDENTIFY_ID_KEY, -1L);
    }

    void setLastIdentifyId(long identifyId) {
        this.dbHelper.insertOrReplaceKeyLongValue(LAST_IDENTIFY_ID_KEY, identifyId);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    long getPreviousSessionId() {
        return this.getLongvalue(PREVIOUS_SESSION_ID_KEY, -1L);
    }

    void setPreviousSessionId(long timestamp) {
        this.dbHelper.insertOrReplaceKeyLongValue(PREVIOUS_SESSION_ID_KEY, timestamp);
    }

    boolean startNewSessionIfNeeded(long timestamp) {
        if (this.inSession()) {
            if (this.isWithinMinTimeBetweenSessions(timestamp)) {
                this.refreshSessionTime(timestamp);
                return false;
            }
            this.startNewSession(timestamp);
            return true;
        }
        if (this.isWithinMinTimeBetweenSessions(timestamp)) {
            long previousSessionId = this.getPreviousSessionId();
            if (previousSessionId == -1L) {
                this.startNewSession(timestamp);
                return true;
            }
            this.setSessionId(previousSessionId);
            this.refreshSessionTime(timestamp);
            return false;
        }
        this.startNewSession(timestamp);
        return true;
    }

    private void startNewSession(long timestamp) {
        if (this.trackingSessionEvents) {
            this.sendSessionEvent(END_SESSION_EVENT);
        }
        this.setSessionId(timestamp);
        this.refreshSessionTime(timestamp);
        if (this.trackingSessionEvents) {
            this.sendSessionEvent(START_SESSION_EVENT);
        }
    }

    private boolean inSession() {
        return this.sessionId >= 0L;
    }

    private boolean isWithinMinTimeBetweenSessions(long timestamp) {
        long lastEventTime = this.getLastEventTime();
        long sessionLimit = this.usingForegroundTracking ? this.minTimeBetweenSessionsMillis : this.sessionTimeoutMillis;
        return timestamp - lastEventTime < sessionLimit;
    }

    private void setSessionId(long timestamp) {
        this.sessionId = timestamp;
        this.setPreviousSessionId(timestamp);
    }

    void refreshSessionTime(long timestamp) {
        if (!this.inSession()) {
            return;
        }
        this.setLastEventTime(timestamp);
    }

    private void sendSessionEvent(String sessionEvent) {
        if (!this.contextAndApiKeySet(String.format("sendSessionEvent('%s')", sessionEvent))) {
            return;
        }
        if (!this.inSession()) {
            return;
        }
        JSONObject apiProperties = new JSONObject();
        try {
            apiProperties.put("special", (Object)sessionEvent);
        }
        catch (JSONException e) {
            return;
        }
        long timestamp = this.getLastEventTime();
        this.logEvent(sessionEvent, null, timestamp, false);
    }

    void onExitForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.refreshSessionTime(timestamp);
                RakamClient.this.inForeground = false;
                RakamClient.this.syncEventsWithServer();
            }
        });
    }

    void onEnterForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.startNewSessionIfNeeded(timestamp);
                RakamClient.this.inForeground = true;
            }
        });
    }

    public void logRevenue(Revenue revenue) {
        if (!this.contextAndApiKeySet("logRevenue()") || revenue == null || !revenue.isValidRevenue()) {
            return;
        }
        this.logEvent("_revenue", revenue.toJSONObject());
    }

    public void setUserProperties(final JSONObject userProperties) {
        if (userProperties == null || userProperties.length() == 0 || !this.contextAndApiKeySet("setUserProperties()")) {
            return;
        }
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                JSONObject copy;
                try {
                    copy = new JSONObject(userProperties.toString());
                }
                catch (JSONException e) {
                    logger.e(RakamClient.TAG, e.toString());
                    return;
                }
                Identify identify = new Identify();
                Iterator keys = copy.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    try {
                        identify.setUserProperty(key, copy.get(key));
                    }
                    catch (JSONException e) {
                        logger.e(RakamClient.TAG, e.toString());
                    }
                }
                RakamClient.this.identify(identify);
            }
        });
    }

    public void clearUserProperties() {
        Identify identify = new Identify().clearAll();
        this.identify(identify);
    }

    public void clearSuperProperties() {
        this.dbHelper.insertOrReplaceKeyValue(SUPER_PROPERTIES_KEY, null);
        this.superProperties = null;
    }

    public void identify(Identify identify) {
        String body;
        if (identify == null || identify.userPropertiesOperations.length() == 0 || !this.contextAndApiKeySet("identify()")) {
            return;
        }
        try {
            JSONObject truncate = this.truncate(identify.userPropertiesOperations);
            body = truncate.put("time", this.getCurrentTimeMillis()).toString();
        }
        catch (JSONException e) {
            this.uploadingCurrently.set(false);
            logger.e(TAG, e.toString());
            return;
        }
        this.recordIdentify(body);
    }

    protected long recordIdentify(String identify) {
        long totalEventCount;
        long identifyId = this.dbHelper.addIdentify(identify);
        this.setLastIdentifyId(identifyId);
        int numEventsToRemove = Math.min(Math.max(1, this.eventMaxCount / 10), 20);
        if (this.dbHelper.getIdentifyCount() > (long)this.eventMaxCount) {
            this.dbHelper.removeIdentifys(this.dbHelper.getNthEventId(numEventsToRemove));
        }
        if ((totalEventCount = this.dbHelper.getIdentifyCount()) % (long)this.eventUploadThreshold == 0L && totalEventCount >= (long)this.eventUploadThreshold) {
            this.syncEventsWithServer();
        } else {
            this.syncServerLater(this.eventUploadPeriodMillis);
        }
        return identifyId;
    }

    protected JSONObject truncate(JSONObject object) {
        if (object == null) {
            return null;
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = object.get(key);
                if (value.getClass().equals(String.class)) {
                    object.put(key, (Object)this.truncate((String)value));
                    continue;
                }
                if (value.getClass().equals(JSONObject.class)) {
                    object.put(key, (Object)this.truncate((JSONObject)value));
                    continue;
                }
                if (!value.getClass().equals(JSONArray.class)) continue;
                object.put(key, (Object)this.truncate((JSONArray)value));
            }
            catch (JSONException e) {
                logger.e(TAG, e.toString());
            }
        }
        return object;
    }

    protected JSONArray truncate(JSONArray array) throws JSONException {
        if (array == null) {
            return null;
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value.getClass().equals(String.class)) {
                array.put(i, (Object)this.truncate((String)value));
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                array.put(i, (Object)this.truncate((JSONObject)value));
                continue;
            }
            if (!value.getClass().equals(JSONArray.class)) continue;
            array.put(i, (Object)this.truncate((JSONArray)value));
        }
        return array;
    }

    protected String truncate(String value) {
        return value.length() <= 1024 ? value : value.substring(0, 1024);
    }

    public Object getUserId() {
        return this.userId;
    }

    public RakamClient setUserId(String userId) {
        if (!this.contextAndApiKeySet("setUserId()")) {
            return this;
        }
        this.userId = userId;
        this.dbHelper.insertOrReplaceKeyValue(USER_ID_KEY, userId);
        return this;
    }

    public RakamClient setUserId(long userId) {
        if (!this.contextAndApiKeySet("setUserId()")) {
            return this;
        }
        this.userId = userId;
        this.dbHelper.insertOrReplaceKeyValue(USER_ID_KEY, userId);
        return this;
    }

    public RakamClient setUserId(int userId) {
        if (!this.contextAndApiKeySet("setUserId()")) {
            return this;
        }
        this.userId = userId;
        this.dbHelper.insertOrReplaceKeyValue(USER_ID_KEY, userId);
        return this;
    }

    public RakamClient setDeviceId(String deviceId) {
        Set<String> invalidDeviceIds = this.getInvalidDeviceIds();
        if (!this.contextAndApiKeySet("setDeviceId()") || TextUtils.isEmpty((CharSequence)deviceId) || invalidDeviceIds.contains(deviceId)) {
            return this;
        }
        this.deviceId = deviceId;
        this.dbHelper.insertOrReplaceKeyValue(DEVICE_ID_KEY, deviceId);
        return this;
    }

    public void uploadEvents() {
        if (!this.contextAndApiKeySet("uploadEvents()")) {
            return;
        }
        this.logThread.post(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.syncEventsWithServer();
            }
        });
    }

    private void syncServerLater(long delayMillis) {
        if (this.updateScheduled.getAndSet(true)) {
            return;
        }
        this.logThread.postDelayed(new Runnable(){

            @Override
            public void run() {
                RakamClient.this.updateScheduled.set(false);
                RakamClient.this.syncEventsWithServer();
            }
        }, delayMillis);
    }

    protected void syncEventsWithServer() {
        this.syncEventsWithServer(false);
    }

    protected void syncEventsWithServer(boolean limit) {
        if (this.optOut || this.offline) {
            return;
        }
        this.updateEvents(limit);
        this.updateIdentifys(limit);
    }

    private void updateIdentifys(boolean limit) {
        if (!this.uploadingCurrently.getAndSet(true)) {
            long totalEventCount;
            long batchSize = Math.min(limit ? (long)this.backoffUploadBatchSize : (long)this.eventUploadMaxBatchSize, totalEventCount = this.dbHelper.getIdentifyCount());
            if (batchSize <= 0L) {
                this.uploadingCurrently.set(false);
                return;
            }
            try {
                final List<JSONObject> identifys = this.dbHelper.getIdentifys(this.getLastIdentifyId(), batchSize);
                if (identifys.size() == 0) {
                    this.uploadingCurrently.set(false);
                    return;
                }
                int maxEventId = -1;
                for (JSONObject event : identifys) {
                    maxEventId = Math.max(event.getInt("event_id"), maxEventId);
                }
                final int finalMaxEventId = maxEventId;
                this.httpThread.post(new Runnable(){

                    @Override
                    public void run() {
                        String body;
                        try {
                            body = new JSONObject().put("data", (Object)RakamClient.this.cleanEventIds(identifys)).put("id", RakamClient.this.getUserId()).put("api", (Object)RakamClient.this.getApi()).toString();
                        }
                        catch (JSONException e) {
                            logger.e(RakamClient.TAG, e.toString());
                            RakamClient.this.uploadingCurrently.set(false);
                            return;
                        }
                        RakamClient.this.makeEventUploadPostRequest(RakamClient.this.httpClient, "/user/batch", body, finalMaxEventId, new CleanerFunction(){

                            @Override
                            public void clean(long id) {
                                RakamClient.this.dbHelper.removeIdentifys(id);
                            }
                        });
                    }
                });
            }
            catch (CursorWindowAllocationException e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, String.format("Caught Cursor window exception during event upload, deferring upload: %s", e.getMessage()));
            }
            catch (Throwable e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, e.toString());
            }
        }
    }

    private void updateEvents(boolean limit) {
        if (!this.uploadingCurrently.getAndSet(true)) {
            long totalEventCount;
            long batchSize = Math.min(limit ? (long)this.backoffUploadBatchSize : (long)this.eventUploadMaxBatchSize, totalEventCount = this.dbHelper.getEventCount());
            if (batchSize <= 0L) {
                this.uploadingCurrently.set(false);
                return;
            }
            try {
                final List<JSONObject> events = this.dbHelper.getEvents(this.getLastEventId(), batchSize);
                if (events.size() == 0) {
                    this.uploadingCurrently.set(false);
                    return;
                }
                int maxEventId = -1;
                for (JSONObject event : events) {
                    maxEventId = Math.max(event.getInt("event_id"), maxEventId);
                }
                final int finalMaxEventId = maxEventId;
                this.httpThread.post(new Runnable(){

                    @Override
                    public void run() {
                        String body;
                        try {
                            body = new JSONObject().put("api", (Object)RakamClient.this.getApi()).put("events", (Object)RakamClient.this.cleanEventIds(events)).toString();
                        }
                        catch (JSONException e) {
                            RakamClient.this.uploadingCurrently.set(false);
                            logger.e(RakamClient.TAG, e.toString());
                            return;
                        }
                        RakamClient.this.makeEventUploadPostRequest(RakamClient.this.httpClient, "/event/batch", body, finalMaxEventId, new CleanerFunction(){

                            @Override
                            public void clean(long id) {
                                RakamClient.this.dbHelper.removeEvents(id);
                            }
                        });
                    }
                });
            }
            catch (CursorWindowAllocationException e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, String.format("Caught Cursor window exception during event upload, deferring upload: %s", e.getMessage()));
            }
            catch (Throwable e) {
                this.uploadingCurrently.set(false);
                logger.e(TAG, e.toString());
            }
        }
    }

    private JSONObject getApi() throws JSONException {
        return new JSONObject().put("api_key", (Object)this.apiKey).put("library", (Object)new JSONObject().put("name", (Object)"rakam-android").put("version", (Object)"2.7.4")).put("upload_time", this.getCurrentTimeMillis());
    }

    private JSONArray cleanEventIds(List<JSONObject> list) throws JSONException {
        JSONArray array = new JSONArray();
        for (JSONObject event : list) {
            event.remove("event_id");
            array.put((Object)event);
        }
        return array;
    }

    protected void makeEventUploadPostRequest(OkHttpClient client, String endpoint, String body, final long maxId, final CleanerFunction cleanerFunction) {
        if (this.apiUrl == null) {
            logger.e(TAG, "The API Url is not set, couldn't send the event data to the server. Please call client.setApiUrl()");
            this.uploadingCurrently.set(false);
            return;
        }
        Request request = new Request.Builder().url(this.apiUrl + endpoint).post(RequestBody.create((MediaType)JSON, (String)body)).build();
        boolean uploadSuccess = false;
        try {
            Response response = client.newCall(request).execute();
            String stringResponse = response.body().string();
            if (stringResponse.equals("1")) {
                uploadSuccess = true;
                logger.d(TAG, "Successfully synced to server");
            } else if (response.code() == 403) {
                logger.e(TAG, "Invalid API key, make sure your API key is correct in initialize()");
            } else if (response.code() == 400) {
                uploadSuccess = true;
                logger.e(TAG, "The data that's being sent is in invalid format, please check this error: " + stringResponse);
            } else if (stringResponse.equals("bad_checksum")) {
                logger.w(TAG, "Bad checksum, post request was mangled in transit, will attempt to reupload later");
            } else if (response.code() == 500) {
                logger.w(TAG, "Couldn't write to request database on server, will attempt to reupload later");
            } else if (response.code() == 413) {
                if (this.backoffUpload && this.backoffUploadBatchSize == 1 && maxId >= 0L) {
                    cleanerFunction.clean(maxId);
                }
                this.backoffUpload = true;
                int numEvents = Math.min((int)this.dbHelper.getEventCount(), this.backoffUploadBatchSize);
                this.backoffUploadBatchSize = (int)Math.ceil((double)numEvents / 2.0);
                logger.w(TAG, "Request too large, will decrease size and attempt to reupload");
                this.logThread.post(new Runnable(){

                    @Override
                    public void run() {
                        RakamClient.this.uploadingCurrently.set(false);
                        RakamClient.this.syncEventsWithServer(true);
                    }
                });
            } else {
                String message = stringResponse == null || stringResponse.isEmpty() ? "empty result" : stringResponse;
                logger.w(TAG, "Upload failed with status code " + response.code() + " and " + message + ", will attempt to reupload later");
            }
        }
        catch (ConnectException e) {
            this.lastError = e;
        }
        catch (UnknownHostException e) {
            this.lastError = e;
        }
        catch (IOException e) {
            logger.e(TAG, e.toString());
            this.lastError = e;
        }
        catch (AssertionError e) {
            logger.e(TAG, "Exception:", (Throwable)((Object)e));
            this.lastError = e;
        }
        catch (Exception e) {
            logger.e(TAG, "Exception:", e);
            this.lastError = e;
        }
        if (!uploadSuccess) {
            this.uploadingCurrently.set(false);
        } else {
            this.logThread.post(new Runnable(){

                @Override
                public void run() {
                    if (maxId >= 0L) {
                        cleanerFunction.clean(maxId);
                    }
                    RakamClient.this.uploadingCurrently.set(false);
                    if (RakamClient.this.dbHelper.getTotalEventCount() > (long)RakamClient.this.eventUploadThreshold) {
                        RakamClient.this.logThread.post(new Runnable(){

                            @Override
                            public void run() {
                                RakamClient.this.syncEventsWithServer(RakamClient.this.backoffUpload);
                            }
                        });
                    } else {
                        RakamClient.this.backoffUpload = false;
                        RakamClient.this.backoffUploadBatchSize = RakamClient.this.eventUploadMaxBatchSize;
                    }
                }
            });
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private Set<String> getInvalidDeviceIds() {
        HashSet<String> invalidDeviceIds = new HashSet<String>();
        invalidDeviceIds.add("");
        invalidDeviceIds.add("9774d56d682e549c");
        invalidDeviceIds.add("unknown");
        invalidDeviceIds.add("000000000000000");
        invalidDeviceIds.add("Android");
        invalidDeviceIds.add("DEFACE");
        return invalidDeviceIds;
    }

    private String initializeDeviceId() {
        String advertisingId;
        Set<String> invalidIds = this.getInvalidDeviceIds();
        String deviceId = this.dbHelper.getValue(DEVICE_ID_KEY);
        if (!TextUtils.isEmpty((CharSequence)deviceId) && !invalidIds.contains(deviceId)) {
            return deviceId;
        }
        if (this.useAdvertisingIdForDeviceId && !TextUtils.isEmpty((CharSequence)(advertisingId = this.deviceInfo.getAdvertisingId())) && !invalidIds.contains(advertisingId)) {
            this.dbHelper.insertOrReplaceKeyValue(DEVICE_ID_KEY, advertisingId);
            return advertisingId;
        }
        String randomId = this.deviceInfo.generateUUID() + "R";
        this.dbHelper.insertOrReplaceKeyValue(DEVICE_ID_KEY, randomId);
        return randomId;
    }

    private void runOnLogThread(Runnable r) {
        if (Thread.currentThread() != this.logThread) {
            this.logThread.post(r);
        } else {
            r.run();
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(URL apiUrl) {
        if (apiUrl == null) {
            logger.e(TAG, "apiUrl can't be null");
            return;
        }
        String scheme = apiUrl.getProtocol();
        String serverName = apiUrl.getHost();
        int serverPort = apiUrl.getPort();
        String address = scheme + "://" + serverName;
        if (apiUrl.getPath() != null && apiUrl.getPath().length() > 0) {
            throw new IllegalStateException(String.format("Please set root address of the API address. A valid example is %s, %s is not valid.", address, apiUrl.toString()));
        }
        if (serverPort > -1) {
            address = address + ":" + serverPort;
        }
        this.apiUrl = address;
    }

    protected Object replaceWithJSONNull(Object obj) {
        return obj == null ? JSONObject.NULL : obj;
    }

    protected synchronized boolean contextAndApiKeySet(String methodName) {
        if (this.context == null) {
            logger.e(TAG, "context cannot be null, set context with initialize() before calling " + methodName);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.apiKey)) {
            logger.e(TAG, "apiKey cannot be null or empty, set apiKey with initialize() before calling " + methodName);
            return false;
        }
        return true;
    }

    protected String bytesToHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static boolean upgradePrefs(Context context) {
        return RakamClient.upgradePrefs(context, null, null);
    }

    static boolean upgradePrefs(Context context, String sourcePkgName, String targetPkgName) {
        try {
            if (sourcePkgName == null) {
                sourcePkgName = "io.rakam.api";
                try {
                    sourcePkgName = Constants.class.getPackage().getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (targetPkgName == null) {
                targetPkgName = "io.rakam.api";
            }
            if (targetPkgName.equals(sourcePkgName)) {
                return false;
            }
            String sourcePrefsName = sourcePkgName + "." + context.getPackageName();
            SharedPreferences source = context.getSharedPreferences(sourcePrefsName, 0);
            if (source.getAll().size() == 0) {
                return false;
            }
            String prefsName = targetPkgName + "." + context.getPackageName();
            SharedPreferences targetPrefs = context.getSharedPreferences(prefsName, 0);
            SharedPreferences.Editor target = targetPrefs.edit();
            if (source.contains(sourcePkgName + ".previousSessionId")) {
                target.putLong("io.rakam.api.previousSessionId", source.getLong(sourcePkgName + ".previousSessionId", -1L));
            }
            if (source.contains(sourcePkgName + ".deviceId")) {
                target.putString("io.rakam.api.deviceId", source.getString(sourcePkgName + ".deviceId", null));
            }
            if (source.contains(sourcePkgName + ".userId")) {
                target.putString("io.rakam.api.userId", source.getString(sourcePkgName + ".userId", null));
            }
            if (source.contains(sourcePkgName + ".optOut")) {
                target.putBoolean("io.rakam.api.optOut", source.getBoolean(sourcePkgName + ".optOut", false));
            }
            target.apply();
            source.edit().clear().apply();
            logger.i(TAG, "Upgraded shared preferences from " + sourcePrefsName + " to " + prefsName);
            return true;
        }
        catch (Exception e) {
            logger.e(TAG, "Error upgrading shared preferences", e);
            return false;
        }
    }

    static boolean upgradeSharedPrefsToDB(Context context) {
        try {
            return RakamClient.upgradeSharedPrefsToDB(context, null);
        }
        catch (Throwable e) {
            logger.e(TAG, "Unknown exception thrown when upgrading DB.", e);
            return false;
        }
    }

    private static boolean upgradeSharedPrefsToDB(Context context, String sourcePkgName) {
        if (sourcePkgName == null) {
            sourcePkgName = "io.rakam.api";
        }
        DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(context);
        String deviceId = dbHelper.getValue(DEVICE_ID_KEY);
        Long previousSessionId = dbHelper.getLongValue(PREVIOUS_SESSION_ID_KEY);
        Long lastEventTime = dbHelper.getLongValue(LAST_EVENT_TIME_KEY);
        if (!TextUtils.isEmpty((CharSequence)deviceId) && previousSessionId != null && lastEventTime != null) {
            return true;
        }
        String prefsName = sourcePkgName + "." + context.getPackageName();
        SharedPreferences preferences = context.getSharedPreferences(prefsName, 0);
        RakamClient.migrateStringValue(preferences, "io.rakam.api.deviceId", null, dbHelper, DEVICE_ID_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.lastEventTime", -1L, dbHelper, LAST_EVENT_TIME_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.lastEventId", -1L, dbHelper, LAST_EVENT_ID_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.lastIdentifyId", -1L, dbHelper, LAST_IDENTIFY_ID_KEY);
        RakamClient.migrateLongValue(preferences, "io.rakam.api.previousSessionId", -1L, dbHelper, PREVIOUS_SESSION_ID_KEY);
        RakamClient.migrateStringValue(preferences, "io.rakam.api.userId", null, dbHelper, USER_ID_KEY);
        RakamClient.migrateBooleanValue(preferences, "io.rakam.api.optOut", false, dbHelper, OPT_OUT_KEY);
        return true;
    }

    private static void migrateLongValue(SharedPreferences prefs, String prefKey, long defValue, DatabaseHelper dbHelper, String dbKey) {
        Long value = dbHelper.getLongValue(dbKey);
        if (value != null) {
            return;
        }
        long oldValue = prefs.getLong(prefKey, defValue);
        dbHelper.insertOrReplaceKeyLongValue(dbKey, oldValue);
        prefs.edit().remove(prefKey).apply();
    }

    private static void migrateStringValue(SharedPreferences prefs, String prefKey, String defValue, DatabaseHelper dbHelper, String dbKey) {
        String value = dbHelper.getValue(dbKey);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        String oldValue = prefs.getString(prefKey, defValue);
        if (!TextUtils.isEmpty((CharSequence)oldValue)) {
            dbHelper.insertOrReplaceKeyValue(dbKey, oldValue);
            prefs.edit().remove(prefKey).apply();
        }
    }

    private static void migrateBooleanValue(SharedPreferences prefs, String prefKey, boolean defValue, DatabaseHelper dbHelper, String dbKey) {
        Long value = dbHelper.getLongValue(dbKey);
        if (value != null) {
            return;
        }
        boolean oldValue = prefs.getBoolean(prefKey, defValue);
        dbHelper.insertOrReplaceKeyLongValue(dbKey, oldValue ? 1L : 0L);
        prefs.edit().remove(prefKey).apply();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static interface CleanerFunction {
        public void clean(long var1);
    }
}

