/*
 * Decompiled with CFR 0.152.
 */
package io.rakam.api;

import android.text.TextUtils;
import io.rakam.api.RakamLog;
import io.rakam.api.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class Revenue {
    public static final String TAG = "Revenue";
    private static RakamLog logger = RakamLog.getLogger();
    protected String productId = null;
    protected int quantity = 1;
    protected Double price = null;
    protected String revenueType = null;
    protected String receipt = null;
    protected String receiptSig = null;
    protected JSONObject properties = null;

    protected boolean isValidRevenue() {
        if (TextUtils.isEmpty((CharSequence)this.productId)) {
            logger.w(TAG, "Invalid revenue, need to set productId field");
            return false;
        }
        if (this.price == null) {
            logger.w(TAG, "Invalid revenue, need to set price");
            return false;
        }
        return true;
    }

    public Revenue setProductId(String productId) {
        if (TextUtils.isEmpty((CharSequence)productId)) {
            logger.w(TAG, "Invalid empty productId");
            return this;
        }
        this.productId = productId;
        return this;
    }

    public Revenue setQuantity(int quantity) {
        this.quantity = quantity;
        return this;
    }

    public Revenue setPrice(double price) {
        this.price = price;
        return this;
    }

    public Revenue setRevenueType(String revenueType) {
        this.revenueType = revenueType;
        return this;
    }

    public Revenue setReceipt(String receipt, String receiptSignature) {
        this.receipt = receipt;
        this.receiptSig = receiptSignature;
        return this;
    }

    public Revenue setEventProperties(JSONObject eventProperties) {
        this.properties = Utils.cloneJSONObject(eventProperties);
        return this;
    }

    protected JSONObject toJSONObject() {
        JSONObject obj = this.properties == null ? new JSONObject() : this.properties;
        try {
            obj.put("_product_id", (Object)this.productId);
            obj.put("_quantity", this.quantity);
            obj.put("_price", (Object)this.price);
            obj.put("_revenue_type", (Object)this.revenueType);
            obj.put("_receipt", (Object)this.receipt);
            obj.put("_receipt_sig", (Object)this.receiptSig);
        }
        catch (JSONException e) {
            logger.e(TAG, String.format("Failed to convert revenue object to JSON: %s", e.toString()));
        }
        return obj;
    }
}

