/*
 * Decompiled with CFR 0.152.
 */
package io.qase.testng;

import io.qase.api.exceptions.QaseException;
import io.qase.api.utils.IntegrationUtils;
import io.qase.client.ApiClient;
import io.qase.client.api.ResultsApi;
import io.qase.client.model.ResultCreate;
import io.qase.client.model.ResultCreateBulk;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.xml.XmlSuite;

public class QaseListener
extends TestListenerAdapter
implements IReporter,
ITestListener {
    private static final Logger logger = LoggerFactory.getLogger(QaseListener.class);
    private final ResultCreateBulk resultCreateBulk = new ResultCreateBulk();
    private final ApiClient apiClient = new ApiClient();
    private final ResultsApi resultsApi = new ResultsApi(this.apiClient);
    private boolean isEnabled = Boolean.parseBoolean(System.getProperty("qase.enable", "false"));
    private boolean useBulk;
    private String projectCode;
    private Integer runId;

    public void onTestSuccess(ITestResult tr) {
        if (this.useBulk) {
            super.onTestSuccess(tr);
        } else {
            this.sendResult(tr, ResultCreate.StatusEnum.PASSED);
        }
    }

    public void onTestFailure(ITestResult tr) {
        if (this.useBulk) {
            super.onTestFailure(tr);
        } else {
            this.sendResult(tr, ResultCreate.StatusEnum.FAILED);
        }
    }

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        if (this.useBulk) {
            List passedTests = this.getPassedTests();
            List failedTests = this.getFailedTests();
            passedTests.forEach(passedTest -> this.addBulkResult((ITestResult)passedTest, ResultCreate.StatusEnum.PASSED));
            failedTests.forEach(passedTest -> this.addBulkResult((ITestResult)passedTest, ResultCreate.StatusEnum.FAILED));
            this.sendBulkResult();
        }
    }

    public QaseListener() {
        if (!this.isEnabled) {
            return;
        }
        this.useBulk = Boolean.parseBoolean(System.getProperty("qase.bulk", "true"));
        String apiToken = System.getProperty("qase.api.token", System.getenv("qase.api.token"));
        if (apiToken == null) {
            this.isEnabled = false;
            logger.info("Required parameter '{}' not specified", (Object)"qase.api.token");
            return;
        }
        String qaseUrl = System.getProperty("qase.url", System.getenv("qase.api.token"));
        if (qaseUrl != null) {
            this.apiClient.setBasePath(qaseUrl);
        }
        this.apiClient.setApiKey(apiToken);
        this.projectCode = System.getProperty("qase.project.code", System.getenv("qase.project.code"));
        if (this.projectCode == null) {
            this.isEnabled = false;
            logger.info("Required parameter '{}' not specified", (Object)"qase.project.code");
            return;
        }
        logger.info("Qase project code - {}", (Object)this.projectCode);
        try {
            this.runId = Integer.valueOf(System.getProperty("qase.run.id", System.getenv("qase.run.id")));
        }
        catch (NumberFormatException e) {
            this.isEnabled = false;
            logger.info("Required parameter '{}' not specified", (Object)"qase.run.id");
            return;
        }
        logger.info("Qase run id - {}", (Object)this.runId);
    }

    private void sendResult(ITestResult result, ResultCreate.StatusEnum status) {
        if (!this.isEnabled) {
            return;
        }
        try {
            this.resultsApi.createResult(this.projectCode, String.valueOf(this.runId), this.getResultItem(result, status));
        }
        catch (QaseException e) {
            logger.error(e.getMessage());
        }
    }

    private void addBulkResult(ITestResult result, ResultCreate.StatusEnum status) {
        if (!this.isEnabled) {
            return;
        }
        this.resultCreateBulk.addResultsItem(this.getResultItem(result, status));
    }

    private void sendBulkResult() {
        if (!this.isEnabled) {
            return;
        }
        try {
            this.resultsApi.createResultBulk(this.projectCode, this.runId, this.resultCreateBulk);
        }
        catch (QaseException e) {
            logger.error(e.getMessage());
        }
    }

    private ResultCreate getResultItem(ITestResult result, ResultCreate.StatusEnum status) {
        Duration timeSpent = Duration.ofMillis(result.getEndMillis() - result.getStartMillis());
        Optional<Throwable> resultThrowable = Optional.ofNullable(result.getThrowable());
        String comment = resultThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
        Boolean isDefect = resultThrowable.flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
        String stacktrace = resultThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        Method method = result.getMethod().getConstructorOrMethod().getMethod();
        Long caseId = IntegrationUtils.getCaseId((Method)method);
        return new ResultCreate().caseId(caseId).status(status).timeMs(Long.valueOf(timeSpent.toMillis())).comment(comment).stacktrace(stacktrace).defect(isDefect);
    }
}

