/*
 * Decompiled with CFR 0.152.
 */
package io.qase.testng;

import io.qase.api.QaseApi;
import io.qase.api.enums.RunResultStatus;
import io.qase.api.exceptions.QaseException;
import io.qase.api.models.v1.testrunresults.Step;
import io.qase.testng.CaseId;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class QaseListener
implements ITestListener {
    private static final Logger logger = LoggerFactory.getLogger(QaseListener.class);
    private static final String REQUIRED_PARAMETER_WARNING_MESSAGE = "Required parameter '{}' not specified";
    private String projectCode;
    private String runId;
    private QaseApi qaseApi;
    private List<Long> cases;
    private static final String PROJECT_CODE_KEY = "qase.project.code";
    private static final String RUN_ID_KEY = "qase.run.id";
    private static final String API_TOKEN_KEY = "qase.api.token";
    private static final String CASE_LIST_KEY = "qase.case.list";

    public QaseListener() {
        String apiToken = System.getProperty(API_TOKEN_KEY, System.getenv(API_TOKEN_KEY));
        if (apiToken == null) {
            logger.info(REQUIRED_PARAMETER_WARNING_MESSAGE, (Object)API_TOKEN_KEY);
            return;
        }
        this.qaseApi = new QaseApi(apiToken);
        this.projectCode = System.getProperty(PROJECT_CODE_KEY, System.getenv(PROJECT_CODE_KEY));
        if (this.projectCode == null) {
            logger.info(REQUIRED_PARAMETER_WARNING_MESSAGE, (Object)PROJECT_CODE_KEY);
            return;
        }
        logger.info("Qase project code - {}", (Object)this.projectCode);
        this.runId = System.getProperty(RUN_ID_KEY, System.getenv(RUN_ID_KEY));
        if (this.runId == null) {
            logger.info(REQUIRED_PARAMETER_WARNING_MESSAGE, (Object)RUN_ID_KEY);
            return;
        }
        logger.info("Qase run id - {}", (Object)this.runId);
        String casesString = System.getProperty(CASE_LIST_KEY, System.getenv(CASE_LIST_KEY));
        if (casesString == null) {
            logger.info(REQUIRED_PARAMETER_WARNING_MESSAGE, (Object)CASE_LIST_KEY);
            return;
        }
        try {
            this.cases = Arrays.stream(casesString.split(",")).map(Long::parseLong).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            logger.info(REQUIRED_PARAMETER_WARNING_MESSAGE, (Object)CASE_LIST_KEY);
        }
        logger.info("Qase cases - {}", this.cases);
    }

    public QaseListener(QaseApi qaseApi) {
        this.qaseApi = qaseApi;
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
        Long caseId = this.getCaseId(result);
        Duration timeSpent = Duration.ofMillis(result.getEndMillis() - result.getStartMillis());
        this.sendResult(caseId, RunResultStatus.passed, timeSpent);
    }

    public void onTestFailure(ITestResult result) {
        Long caseId = this.getCaseId(result);
        Duration timeSpent = Duration.ofMillis(result.getEndMillis() - result.getStartMillis());
        this.sendResult(caseId, RunResultStatus.failed, timeSpent);
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    private void sendResult(Long caseId, RunResultStatus status, Duration timeSpent) {
        if (caseId != null && this.cases != null && this.cases.contains(caseId)) {
            try {
                this.qaseApi.testRunResults().create(this.projectCode, Long.parseLong(this.runId), caseId.longValue(), status, timeSpent, null, null, null, new Step[0]);
            }
            catch (QaseException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private Long getCaseId(ITestResult result) {
        Method method = result.getMethod().getConstructorOrMethod().getMethod();
        if (method.isAnnotationPresent(CaseId.class)) {
            return method.getDeclaredAnnotation(CaseId.class).value();
        }
        return null;
    }
}

