/*
 * Decompiled with CFR 0.152.
 */
package io.qase.cucumber4;

import cucumber.api.Result;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import gherkin.pickles.PickleTag;
import io.qase.api.QaseClient;
import io.qase.api.StepStorage;
import io.qase.api.services.QaseTestCaseListener;
import io.qase.api.utils.CucumberUtils;
import io.qase.api.utils.IntegrationUtils;
import io.qase.client.model.ResultCreate;
import io.qase.configuration.QaseModule;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class QaseEventListener
implements ConcurrentEventListener {
    private static final String REPORTER_NAME = "Cucumber 4-JVM";
    private final AtomicReference<Object> qaseTestCaseListener = new AtomicReference();

    public void setEventPublisher(EventPublisher publisher) {
        if (QaseClient.isEnabled()) {
            publisher.registerHandlerFor(TestCaseStarted.class, this::testCaseStarted);
            publisher.registerHandlerFor(TestCaseFinished.class, this::testCaseFinished);
            publisher.registerHandlerFor(TestRunFinished.class, this::testRunFinished);
        }
    }

    private void testRunFinished(TestRunFinished testRunFinished) {
        this.getQaseTestCaseListener().onTestCasesSetFinished();
    }

    private void testCaseStarted(TestCaseStarted event) {
        this.getQaseTestCaseListener().onTestCaseStarted();
    }

    private void testCaseFinished(TestCaseFinished event) {
        this.getQaseTestCaseListener().onTestCaseFinished(resultCreate -> this.setupResultItem((ResultCreate)resultCreate, event));
    }

    private ResultCreate setupResultItem(ResultCreate resultCreate, TestCaseFinished event) {
        List pickleTags = event.testCase.getTags();
        List tags = pickleTags.stream().map(PickleTag::getName).collect(Collectors.toList());
        Long caseId = CucumberUtils.getCaseId(tags);
        ResultCreate.StatusEnum status = this.convertStatus(event.result.getStatus());
        Optional<Throwable> optionalThrowable = Optional.ofNullable(event.result.getError());
        String comment = optionalThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
        Boolean isDefect = optionalThrowable.flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
        String stacktrace = optionalThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        LinkedList steps = StepStorage.stopSteps();
        return resultCreate.caseId(caseId).status(status).comment(comment).stacktrace(stacktrace).steps((List)(steps.isEmpty() ? null : steps)).defect(isDefect);
    }

    private ResultCreate.StatusEnum convertStatus(Result.Type status) {
        switch (status) {
            case FAILED: {
                return ResultCreate.StatusEnum.FAILED;
            }
            case PASSED: {
                return ResultCreate.StatusEnum.PASSED;
            }
        }
        return ResultCreate.StatusEnum.SKIPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QaseTestCaseListener getQaseTestCaseListener() {
        Object value = this.qaseTestCaseListener.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.qaseTestCaseListener;
            synchronized (atomicReference) {
                value = this.qaseTestCaseListener.get();
                if (value == null) {
                    QaseTestCaseListener actualValue = (QaseTestCaseListener)QaseModule.INJECTOR.getInstance(QaseTestCaseListener.class);
                    value = actualValue == null ? this.qaseTestCaseListener : actualValue;
                    this.qaseTestCaseListener.set(value);
                }
            }
        }
        return (QaseTestCaseListener)(value == this.qaseTestCaseListener ? null : value);
    }

    static {
        System.setProperty("QASE_CLIENT_REPORTER_NAME", REPORTER_NAME);
    }
}

