/*
 * Decompiled with CFR 0.152.
 */
package io.qase.cucumber4;

import cucumber.api.Result;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import gherkin.pickles.PickleTag;
import io.qase.api.QaseClient;
import io.qase.api.StepStorage;
import io.qase.api.exceptions.QaseException;
import io.qase.api.utils.CucumberUtils;
import io.qase.api.utils.IntegrationUtils;
import io.qase.client.ApiClient;
import io.qase.client.api.ResultsApi;
import io.qase.client.api.RunsApi;
import io.qase.client.model.ResultCreate;
import io.qase.client.model.ResultCreateBulk;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QaseEventListener
implements ConcurrentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(QaseEventListener.class);
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final ResultCreateBulk resultCreateBulk = new ResultCreateBulk();
    private ResultsApi resultsApi;
    private RunsApi runsApi;

    public QaseEventListener() {
        if (QaseClient.isEnabled()) {
            ApiClient apiClient = QaseClient.getApiClient();
            this.resultsApi = new ResultsApi(apiClient);
            this.runsApi = new RunsApi(apiClient);
            apiClient.addDefaultHeader("X-CLIENT-REPORTER", "Cucumber 4-JVM");
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        if (QaseClient.isEnabled()) {
            publisher.registerHandlerFor(TestCaseStarted.class, this::testCaseStarted);
            publisher.registerHandlerFor(TestCaseFinished.class, this::testCaseFinished);
            publisher.registerHandlerFor(TestRunFinished.class, this::testRunFinished);
        }
    }

    private void testRunFinished(TestRunFinished testRunFinished) {
        if (QaseClient.getConfig().useBulk()) {
            this.sendBulkResult();
        }
        if (QaseClient.getConfig().runAutocomplete()) {
            try {
                this.runsApi.completeRun(QaseClient.getConfig().projectCode(), QaseClient.getConfig().runId());
            }
            catch (QaseException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private void testCaseStarted(TestCaseStarted event) {
        this.startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCaseFinished(TestCaseFinished event) {
        try {
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.startTime.get());
            List pickleTags = event.testCase.getTags();
            List tags = pickleTags.stream().map(PickleTag::getName).collect(Collectors.toList());
            Long caseId = CucumberUtils.getCaseId(tags);
            if (caseId == null) {
                return;
            }
            if (QaseClient.getConfig().useBulk()) {
                this.addBulkResult(caseId, duration, event.result);
            } else {
                this.send(caseId, duration, event.result);
            }
        }
        finally {
            this.startTime.remove();
        }
    }

    private void addBulkResult(Long caseId, Duration duration, Result result) {
        this.resultCreateBulk.addResultsItem(this.getResultItem(caseId, duration, result));
    }

    private void sendBulkResult() {
        try {
            this.resultsApi.createResultBulk(QaseClient.getConfig().projectCode(), QaseClient.getConfig().runId(), this.resultCreateBulk);
            this.resultCreateBulk.getResults().clear();
        }
        catch (QaseException e) {
            logger.error(e.getMessage());
        }
    }

    private void send(Long caseId, Duration duration, Result result) {
        if (!QaseClient.isEnabled()) {
            return;
        }
        try {
            this.resultsApi.createResult(QaseClient.getConfig().projectCode(), QaseClient.getConfig().runId(), this.getResultItem(caseId, duration, result));
        }
        catch (QaseException e) {
            logger.error(e.getMessage());
        }
    }

    public ResultCreate getResultItem(Long caseId, Duration duration, Result result) {
        ResultCreate.StatusEnum status = this.convertStatus(result.getStatus());
        if (status == null) {
            return null;
        }
        Optional<Throwable> optionalThrowable = Optional.ofNullable(result.getError());
        String comment = optionalThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
        Boolean isDefect = optionalThrowable.flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
        String stacktrace = optionalThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        LinkedList steps = StepStorage.getSteps();
        return new ResultCreate().caseId(caseId).status(status).timeMs(Long.valueOf(duration.toMillis())).comment(comment).stacktrace(stacktrace).steps((List)(steps.isEmpty() ? null : steps)).defect(isDefect);
    }

    private ResultCreate.StatusEnum convertStatus(Result.Type status) {
        switch (status) {
            case FAILED: {
                return ResultCreate.StatusEnum.FAILED;
            }
            case PASSED: {
                return ResultCreate.StatusEnum.PASSED;
            }
        }
        return ResultCreate.StatusEnum.SKIPPED;
    }
}

