/*
 * Decompiled with CFR 0.152.
 */
package io.qase.cucumber4;

import cucumber.api.Result;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import gherkin.pickles.PickleTag;
import io.qase.api.exceptions.QaseException;
import io.qase.api.utils.IntegrationUtils;
import io.qase.client.ApiClient;
import io.qase.client.api.ResultsApi;
import io.qase.client.model.ResultCreate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QaseEventListener
implements ConcurrentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(QaseEventListener.class);
    private final ApiClient apiClient = new ApiClient();
    private final ResultsApi resultsApi = new ResultsApi(this.apiClient);
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private boolean isEnabled = Boolean.parseBoolean(System.getProperty("qase.enable", "false"));
    private String projectCode;
    private String runId;

    public QaseEventListener() {
        if (!this.isEnabled) {
            return;
        }
        String apiToken = System.getProperty("qase.api.token", System.getenv("qase.api.token"));
        if (apiToken == null) {
            this.isEnabled = false;
            logger.info("Required parameter '{}' not specified", (Object)"qase.api.token");
            return;
        }
        String qaseUrl = System.getProperty("qase.url", System.getenv("qase.api.token"));
        if (qaseUrl != null) {
            this.apiClient.setBasePath(qaseUrl);
        }
        this.apiClient.setApiKey(apiToken);
        this.projectCode = System.getProperty("qase.project.code", System.getenv("qase.project.code"));
        if (this.projectCode == null) {
            this.isEnabled = false;
            logger.info("Required parameter '{}' not specified", (Object)"qase.project.code");
            return;
        }
        logger.info("Qase project code - {}", (Object)this.projectCode);
        this.runId = System.getProperty("qase.run.id", System.getenv("qase.run.id"));
        if (this.runId == null) {
            this.isEnabled = false;
            logger.info("Required parameter '{}' not specified", (Object)"qase.run.id");
            return;
        }
        logger.info("Qase run id - {}", (Object)this.runId);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this::testCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::testCaseFinished);
    }

    private void testCaseStarted(TestCaseStarted event) {
        this.startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCaseFinished(TestCaseFinished event) {
        try {
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.startTime.get());
            List tags = event.testCase.getTags();
            Long caseId = this.getCaseId(tags);
            if (caseId != null) {
                this.send(caseId, duration, event.result);
            }
        }
        finally {
            this.startTime.remove();
        }
    }

    private Long getCaseId(List<PickleTag> tags) {
        for (PickleTag pickleTag : tags) {
            String tag = pickleTag.getName();
            String[] split = tag.split("=");
            if (!IntegrationUtils.CASE_TAGS.contains(split[0]) || split.length != 2 || !split[1].matches("\\d+")) continue;
            return Long.valueOf(split[1]);
        }
        return null;
    }

    private void send(Long caseId, Duration duration, Result result) {
        if (!this.isEnabled) {
            return;
        }
        try {
            ResultCreate.StatusEnum status = this.convertStatus(result.getStatus());
            if (status == null) {
                return;
            }
            Optional<Throwable> optionalThrowable = Optional.ofNullable(result.getError());
            String comment = optionalThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
            Boolean isDefect = optionalThrowable.flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
            String stacktrace = optionalThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
            this.resultsApi.createResult(this.projectCode, this.runId, new ResultCreate().caseId(caseId).status(status).timeMs(Long.valueOf(duration.toMillis())).comment(comment).stacktrace(stacktrace).defect(isDefect));
        }
        catch (QaseException e) {
            logger.error(e.getMessage());
        }
    }

    private ResultCreate.StatusEnum convertStatus(Result.Type status) {
        switch (status) {
            case FAILED: {
                return ResultCreate.StatusEnum.FAILED;
            }
            case PASSED: {
                return ResultCreate.StatusEnum.PASSED;
            }
        }
        return ResultCreate.StatusEnum.SKIPPED;
    }
}

