/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.testruns.NewTestRun;
import io.qase.api.models.v1.testruns.TestRun;
import io.qase.api.models.v1.testruns.TestRuns;
import io.qase.api.services.TestRunService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public final class TestRunServiceImpl
implements TestRunService {
    private final QaseApiClient qaseApiClient;

    public TestRunServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public TestRuns getAll(String projectCode, int limit, int offset, RouteFilter filter, boolean includeCases) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("limit", limit);
        queryParams.put("offset", offset);
        if (includeCases) {
            queryParams.put("include", "cases");
        }
        return this.qaseApiClient.get(TestRuns.class, "/run/{code}", Collections.singletonMap("code", projectCode), queryParams, filter);
    }

    @Override
    public TestRuns getAll(String projectCode, boolean includeCases) {
        return this.getAll(projectCode, 100, 0, this.filter(), includeCases);
    }

    @Override
    public TestRun get(String projectCode, long id, boolean includeCases) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", id);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (includeCases) {
            queryParams.put("include", "cases");
        }
        return this.qaseApiClient.get(TestRun.class, "/run/{code}/{id}", routeParams, queryParams);
    }

    @Override
    public long create(String projectCode, String title, Integer environmentId, String description, Integer ... cases) {
        NewTestRun createUpdateTestRunRequest = new NewTestRun(title, Arrays.asList(cases));
        createUpdateTestRunRequest.setDescription(description);
        createUpdateTestRunRequest.setEnvironmentId(environmentId);
        return this.qaseApiClient.post(TestRun.class, "/run/{code}", Collections.singletonMap("code", projectCode), createUpdateTestRunRequest).getId();
    }

    @Override
    public long create(String projectCode, String title, Integer ... cases) {
        return this.create(projectCode, title, (Integer)null, (String)null, cases);
    }

    @Override
    public boolean delete(String projectCode, long testRunId) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", testRunId);
        return (Boolean)this.qaseApiClient.delete("/run/{code}/{id}", routeParams).get("status");
    }
}

