/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.suites.NewSuite;
import io.qase.api.models.v1.suites.Suite;
import io.qase.api.models.v1.suites.Suites;
import io.qase.api.services.SuiteService;
import java.util.Collections;
import java.util.HashMap;

public final class SuiteServiceImpl
implements SuiteService {
    private final QaseApiClient qaseApiClient;

    public SuiteServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public Suites getAll(String projectCode, int limit, int offset, RouteFilter filter) {
        return this.qaseApiClient.get(Suites.class, "/suite/{code}", Collections.singletonMap("code", projectCode), filter, limit, offset);
    }

    @Override
    public Suites getAll(String projectCode) {
        return this.getAll(projectCode, 100, 0, this.filter());
    }

    @Override
    public Suite get(String projectCode, long suiteId) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", suiteId);
        return this.qaseApiClient.get(Suite.class, "/suite/{code}/{id}", routeParams);
    }

    @Override
    public long create(String projectCode, String title, String description, String precondition, Integer parentId) {
        NewSuite createUpdateSuiteRequest = new NewSuite(title);
        createUpdateSuiteRequest.setDescription(description);
        createUpdateSuiteRequest.setPreconditions(precondition);
        createUpdateSuiteRequest.setParentId(parentId);
        return this.qaseApiClient.post(Suite.class, "/suite/{code}", Collections.singletonMap("code", projectCode), createUpdateSuiteRequest).getId();
    }

    @Override
    public long create(String projectCode, String title) {
        return this.create(projectCode, title, null, null, null);
    }

    @Override
    public long create(String projectCode, String title, String description) {
        return this.create(projectCode, title, description, null, null);
    }

    @Override
    public long create(String projectCode, String title, String description, String precondition) {
        return this.create(projectCode, title, description, precondition, null);
    }

    @Override
    public long update(String projectCode, long testSuiteId, String title, String description, String preconditions, Integer parentId) {
        NewSuite createUpdateSuiteRequest = new NewSuite(title);
        createUpdateSuiteRequest.setDescription(description);
        createUpdateSuiteRequest.setPreconditions(preconditions);
        createUpdateSuiteRequest.setParentId(parentId);
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", testSuiteId);
        return this.qaseApiClient.patch(Suite.class, "/suite/{code}/{id}", routeParams, createUpdateSuiteRequest).getId();
    }

    @Override
    public long update(String projectCode, long testSuiteId, String title, String description, String preconditions) {
        return this.update(projectCode, testSuiteId, title, description, preconditions, null);
    }

    @Override
    public long update(String projectCode, long testSuiteId, String title, String description) {
        return this.update(projectCode, testSuiteId, title, description, null, null);
    }

    @Override
    public long update(String projectCode, long testSuiteId, String title) {
        return this.update(projectCode, testSuiteId, title, null, null, null);
    }

    @Override
    public boolean delete(String projectCode, long testSuiteId) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", testSuiteId);
        return (Boolean)this.qaseApiClient.delete("/suite/{code}/{id}", routeParams).get("status");
    }
}

