/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.common.swaggerui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.pythagoras.common.swaggerui.SwaggerProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.OAuthBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiKeyVehicle;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    private String serviceName;
    private String serviceDesc = "desr";
    private String clientId = "gigy";
    private String clientSecret = "secret";
    private String authorizationServiceEndpoint;

    @Autowired
    public void setProperties(SwaggerProperties properties) {
        this.serviceName = properties.getName();
        this.serviceDesc = properties.getDescription();
        this.clientId = properties.getOauth().getClientId();
        this.clientSecret = properties.getOauth().getClientSecret();
        this.authorizationServiceEndpoint = properties.getAuthorizationTokenEndpoint();
    }

    @Bean
    public Docket postsApi() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("public-api").apiInfo(this.apiInfo()).select().paths(this.postPaths()).apis(Predicates.not((Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.boot"))).paths(this.springBootActuatorJmxPaths()).build().securitySchemes(Collections.singletonList(this.oauth()));
    }

    private Predicate<String> postPaths() {
        return PathSelectors.regex((String)"/.*");
    }

    private Predicate<String> springBootActuatorJmxPaths() {
        return PathSelectors.regex((String)"^/(?!env|restart|pause|resume|refresh).*$");
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.serviceName).description(this.serviceDesc).build();
    }

    @Bean
    List<GrantType> grantTypes() {
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        ResourceOwnerPasswordCredentialsGrant grantType = new ResourceOwnerPasswordCredentialsGrant(this.authorizationServiceEndpoint);
        grantTypes.add((GrantType)grantType);
        return grantTypes;
    }

    @Bean
    SecurityScheme oauth() {
        return new OAuthBuilder().name("OAuth2").scopes(this.scopes()).grantTypes(this.grantTypes()).build();
    }

    private List<AuthorizationScope> scopes() {
        ArrayList<AuthorizationScope> list = new ArrayList<AuthorizationScope>();
        list.add(new AuthorizationScope("read", "Grants read access"));
        list.add(new AuthorizationScope("write", "Grants write access"));
        return list;
    }

    @Bean
    public SecurityConfiguration securityInfo() {
        return new SecurityConfiguration(this.clientId, this.clientSecret, "realm", this.clientId, "apiKey", ApiKeyVehicle.HEADER, "api_key", ",");
    }
}

