/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.common.simplecors;

import io.pythagoras.common.simplecors.CorsProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SimpleCorsFilter
implements Filter {
    private CorsProperties properties;

    @Autowired
    public SimpleCorsFilter(CorsProperties properties) {
        this.properties = properties;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        response.setHeader("Access-Control-Allow-Origin", this.properties.getAllowOrigin());
        response.setHeader("Access-Control-Allow-Methods", this.properties.getAllowMethods());
        response.setHeader("Access-Control-Max-Age", this.properties.getMaxAge());
        response.setHeader("Access-Control-Allow-Headers", this.properties.getAllowHeaders());
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(200);
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

