/*
 * Decompiled with CFR 0.152.
 */
package io.pythagoras.common.grayloglogger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.google.gson.Gson;
import io.pythagoras.common.grayloglogger.config.GraylogProperties;
import io.pythagoras.common.loggercommon.LogObject;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfMessageBuilder;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GraylogAppender
extends AppenderBase<ILoggingEvent> {
    private GelfTransport transport;
    private GraylogProperties properties;
    private String appName;

    @Autowired
    public void setProperties(GraylogProperties properties) {
        this.properties = properties;
    }

    @Value(value="${spring.application.name:NAME_NOT_FOUND}")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void start() {
        this.configure();
        super.start();
    }

    protected void append(ILoggingEvent eventObject) {
        Gson gson = new Gson();
        GelfMessageBuilder message = new GelfMessageBuilder(eventObject.getFormattedMessage(), this.properties.getHost());
        message.level(this.convertLevels(eventObject.getLevel())).additionalField("app_name", (Object)this.appName).additionalField("timestamp", (Object)eventObject.getTimeStamp());
        Object[] args = eventObject.getArgumentArray();
        if (args != null && args.length > 0) {
            Object obj = args[0];
            if (obj instanceof LogObject) {
                LogObject lobj = (LogObject)obj;
                message.additionalField("statusCode", (Object)lobj.statusCode).additionalField("stackTrace", (Object)gson.toJson((Object)lobj.exception.getStackTrace()));
                if (args.length > 1) {
                    message.additionalField("objects", (Object)gson.toJson((Object)Arrays.copyOfRange(args, 1, args.length - 1)));
                }
            } else {
                message.additionalField("objects", (Object)gson.toJson((Object)args));
            }
        } else if (eventObject.getThrowableProxy() != null) {
            message.additionalField("stackTrace", (Object)gson.toJson((Object)eventObject.getThrowableProxy().getStackTraceElementProxyArray()));
        }
        Boolean sendResult = this.transport.trySend(message.build());
        if (!sendResult.booleanValue()) {
            System.out.println("ERROR: Graylog buffer full.");
        }
    }

    private void configure() {
        GelfConfiguration config = new GelfConfiguration(new InetSocketAddress(this.properties.getHost(), (int)this.properties.getPort())).transport(GelfTransports.UDP).queueSize(512).connectTimeout(5000).reconnectDelay(1000).tcpNoDelay(true).sendBufferSize(32768);
        this.transport = GelfTransports.create((GelfConfiguration)config);
    }

    private GelfMessageLevel convertLevels(Level inLevel) {
        switch (inLevel.toInt()) {
            case -2147483648: 
            case 0x7FFFFFFF: {
                return GelfMessageLevel.DEBUG;
            }
            case 5000: 
            case 10000: {
                return GelfMessageLevel.DEBUG;
            }
            case 40000: {
                return GelfMessageLevel.ERROR;
            }
            case 20000: {
                return GelfMessageLevel.INFO;
            }
            case 30000: {
                return GelfMessageLevel.WARNING;
            }
        }
        throw new RuntimeException("Unable to convert Log Level");
    }
}

