/*
 * Decompiled with CFR 0.152.
 */
package io.pyroclast.pyroclastjava.v1.topic;

import io.pyroclast.pyroclastjava.v1.exceptions.PyroclastAPIException;
import io.pyroclast.pyroclastjava.v1.topic.PyroclastConsumer;
import io.pyroclast.pyroclastjava.v1.topic.PyroclastProducer;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class PyroclastTopicClient {
    private static final String VERSION = "v1";
    private static final String DEFAULT_REGION = "us-east-1";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String topicId;
    private String readApiKey;
    private String writeApiKey;
    private String endpoint;
    private String region = "us-east-1";
    private String format = "application/json";
    private boolean validated = false;

    public PyroclastTopicClient withTopicId(String topicId) {
        this.topicId = topicId;
        return this;
    }

    public PyroclastTopicClient withReadApiKey(String readApiKey) {
        this.readApiKey = readApiKey;
        return this;
    }

    public PyroclastTopicClient withWriteApiKey(String writeApiKey) {
        this.writeApiKey = writeApiKey;
        return this;
    }

    public PyroclastTopicClient withFormat(String format) {
        this.format = format;
        return this;
    }

    public PyroclastTopicClient withRegion(String region) {
        this.region = region;
        return this;
    }

    public PyroclastTopicClient withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public PyroclastTopicClient buildClient() {
        if (this.topicId == null) {
            throw new IllegalArgumentException("Topic ID must be configured.");
        }
        if (this.readApiKey == null && this.writeApiKey == null) {
            throw new IllegalArgumentException("Read or Write API Key must be configured.");
        }
        this.validated = true;
        return this;
    }

    private void ensureBaseAttributes() {
        if (!this.validated) {
            throw new IllegalArgumentException("Must call buildClient before executing API methods on this object.");
        }
    }

    public void ensureReadApiKey() {
        if (this.readApiKey == null) {
            throw new IllegalArgumentException("Must configure client with a Read API Key to use this method.");
        }
    }

    public void ensureWriteApiKey() {
        if (this.writeApiKey == null) {
            throw new IllegalArgumentException("Must configure client with a Write API Key to use this method.");
        }
    }

    private String buildEndpoint() {
        if (this.endpoint != null) {
            return String.format("%s/%s/topics", this.endpoint, VERSION);
        }
        if (this.region != null) {
            return String.format("https://api.%s.pyroclast.io/%s/topics", this.region, VERSION);
        }
        return String.format("https://api.%s.pyroclast.io/%s/topics", DEFAULT_REGION, VERSION);
    }

    public PyroclastProducer createProducer() {
        this.ensureBaseAttributes();
        this.ensureWriteApiKey();
        return new PyroclastProducer(this.topicId, this.writeApiKey, this.format, this.buildEndpoint());
    }

    /*
     * Exception decompiling
     */
    public PyroclastConsumer createConsumer(String subscriptionName) throws IOException, PyroclastAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

