/*
 * Decompiled with CFR 0.152.
 */
package io.pyroclast.pyroclastjava.v1.deployment.parsers;

import io.pyroclast.pyroclastjava.v1.ResponseParser;
import io.pyroclast.pyroclastjava.v1.deployment.responses.ReadAggregateResult;
import io.pyroclast.pyroclastjava.v1.exceptions.MalformedEventException;
import io.pyroclast.pyroclastjava.v1.exceptions.PyroclastAPIException;
import io.pyroclast.pyroclastjava.v1.exceptions.UnauthorizedAccessException;
import io.pyroclast.pyroclastjava.v1.exceptions.UnknownAPIException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.codehaus.jackson.map.ObjectMapper;

public class ReadAggregateParser
implements ResponseParser<ReadAggregateResult> {
    @Override
    public ReadAggregateResult parseResponse(HttpResponse response, ObjectMapper mapper) throws IOException, PyroclastAPIException {
        int status = response.getStatusLine().getStatusCode();
        switch (status) {
            case 200: {
                HttpEntity entity = response.getEntity();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)entity.getContent(), (Writer)writer, (String)"UTF-8");
                String json = writer.toString();
                return (ReadAggregateResult)mapper.readValue(json, ReadAggregateResult.class);
            }
            case 400: {
                throw new MalformedEventException();
            }
            case 401: {
                throw new UnauthorizedAccessException();
            }
        }
        throw new UnknownAPIException(response.getStatusLine().toString());
    }
}

