/*
 * Decompiled with CFR 0.152.
 */
package io.pyroclast.pyroclastjava.v1.deployment.deserializers;

import io.pyroclast.pyroclastjava.v1.deployment.DeploymentAggregate;
import io.pyroclast.pyroclastjava.v1.deployment.DeploymentAggregates;
import io.pyroclast.pyroclastjava.v1.deployment.Window;
import io.pyroclast.pyroclastjava.v1.deployment.responses.ReadAggregatesResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.deser.std.StdDeserializer;

public class ReadAggregatesResponseDeserializer
extends StdDeserializer<ReadAggregatesResult> {
    public ReadAggregatesResponseDeserializer() {
        this(null);
    }

    public ReadAggregatesResponseDeserializer(Class<?> vc) {
        super(vc);
    }

    public ReadAggregatesResult deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
        JsonNode node = jp.getCodec().readTree(jp);
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<DeploymentAggregate> aggregates = new ArrayList<DeploymentAggregate>();
        Iterator fieldsIterator = node.getFields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            JsonNode subnode = (JsonNode)field.getValue();
            String aggregateName = (String)field.getKey();
            String id = subnode.get("id").asText();
            String type = subnode.get("type").asText();
            boolean isGrouped = subnode.get("grouped?").asBoolean();
            JsonNode contents = subnode.get("contents");
            if (contents.isArray()) {
                ArrayList<Window> parsedWindows = new ArrayList<Window>();
                for (JsonNode n : contents) {
                    Window window = (Window)mapper.readValue(n.toString(), Window.class);
                    parsedWindows.add(window);
                }
                aggregates.add(new DeploymentAggregate(id, type, isGrouped).withName(aggregateName).withUngroupedContents(parsedWindows));
                continue;
            }
            Iterator fit = contents.getFields();
            HashMap<String, List<Window>> parsedWindows = new HashMap<String, List<Window>>();
            while (fit.hasNext()) {
                ArrayList<Window> windows = new ArrayList<Window>();
                Map.Entry contentField = (Map.Entry)fit.next();
                String groupName = (String)contentField.getKey();
                JsonNode groupedContents = (JsonNode)contentField.getValue();
                for (JsonNode n : groupedContents) {
                    Window window = (Window)mapper.readValue(n.toString(), Window.class);
                    windows.add(window);
                }
                parsedWindows.put(groupName, windows);
            }
            aggregates.add(new DeploymentAggregate(id, type, isGrouped).withGroupedContents(parsedWindows));
        }
        DeploymentAggregates da = new DeploymentAggregates(aggregates);
        return new ReadAggregatesResult(true, da);
    }
}

