/*
 * Decompiled with CFR 0.152.
 */
package io.pyroclast.pyroclastjava.v1.async;

import io.pyroclast.pyroclastjava.v1.ResponseParser;
import io.pyroclast.pyroclastjava.v1.async.AsyncCancelledCallback;
import io.pyroclast.pyroclastjava.v1.async.AsyncFailCallback;
import io.pyroclast.pyroclastjava.v1.async.AsyncSuccessCallback;
import io.pyroclast.pyroclastjava.v1.topic.PyroclastTopicClient;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.codehaus.jackson.map.ObjectMapper;

public class AsyncCallback
implements FutureCallback<HttpResponse> {
    private final CloseableHttpAsyncClient client;
    private final ResponseParser responseParser;
    private final ObjectMapper mapper;
    private final AsyncSuccessCallback onSuccess;
    private final AsyncFailCallback onFail;
    private final AsyncCancelledCallback onCancel;

    public AsyncCallback(CloseableHttpAsyncClient client, ResponseParser rp, ObjectMapper mapper, AsyncSuccessCallback onSuccess, AsyncFailCallback onFail, AsyncCancelledCallback onCancel) {
        this.client = client;
        this.responseParser = rp;
        this.mapper = mapper;
        this.onSuccess = onSuccess;
        this.onFail = onFail;
        this.onCancel = onCancel;
    }

    public void completed(HttpResponse t) {
        try {
            this.onSuccess.invoke(this.responseParser.parseResponse(t, this.mapper));
        }
        catch (Throwable ex) {
            Logger.getLogger(PyroclastTopicClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncCallback.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void failed(Exception excptn) {
        try {
            this.onFail.invoke(excptn);
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncCallback.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void cancelled() {
        try {
            this.onCancel.invoke(-1);
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException ex) {
                Logger.getLogger(AsyncCallback.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

