/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.thymeleaf.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.purplejs.core.Engine;
import io.purplejs.core.exception.ProblemException;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.core.value.ScriptValue;
import io.purplejs.thymeleaf.ThymeleafService;
import io.purplejs.thymeleaf.internal.TemplateResolverImpl;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateresolver.ITemplateResolver;

final class ThymeleafServiceImpl
implements ThymeleafService {
    private final TemplateEngine engine = new TemplateEngine();

    ThymeleafServiceImpl() {
        this.engine.setDialects(ThymeleafServiceImpl.loadDialects());
    }

    void initialize(Engine engine) {
        TemplateResolverImpl resolver = new TemplateResolverImpl(engine.getResourceLoader());
        this.engine.setTemplateResolver((ITemplateResolver)resolver);
    }

    @Override
    public String render(ResourcePath view, ScriptValue model) {
        try {
            return this.doRender(view, ThymeleafServiceImpl.toMap(model));
        }
        catch (RuntimeException e) {
            throw ThymeleafServiceImpl.handleError(e);
        }
    }

    private String doRender(ResourcePath view, Map<String, Object> model) {
        Context context = new Context();
        context.setVariables(model);
        return this.engine.process(view.toString(), (IContext)context);
    }

    static RuntimeException handleError(RuntimeException e) {
        if (e instanceof TemplateProcessingException) {
            return ThymeleafServiceImpl.handleError((TemplateProcessingException)e);
        }
        return e;
    }

    private static RuntimeException handleError(TemplateProcessingException e) {
        int lineNumber = e.getLine() != null ? e.getLine() : 0;
        ResourcePath path = e.getTemplateName() != null ? ResourcePath.from((String)e.getTemplateName()) : null;
        return ProblemException.newBuilder().lineNumber(lineNumber).path(path).cause((Throwable)e).message(e.getMessage(), new Object[0]).build();
    }

    private static Set<IDialect> loadDialects() {
        return Sets.newHashSet(ServiceLoader.load(IDialect.class));
    }

    private static Map<String, Object> toMap(ScriptValue value) {
        if (value == null) {
            return Maps.newHashMap();
        }
        Object result = value.toJavaObject();
        if (result instanceof Map) {
            return (Map)result;
        }
        return Maps.newHashMap();
    }
}

