/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.thymeleaf.internal;

import com.google.common.io.ByteSource;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.core.util.IOHelper;
import io.purplejs.thymeleaf.internal.TemplateResourceResolver;
import java.io.IOException;
import java.io.Reader;
import org.thymeleaf.templateresource.ITemplateResource;

final class TemplateResourceImpl
implements ITemplateResource {
    private final Resource resource;
    private final ResourcePath path;
    private final TemplateResourceResolver resolver;

    TemplateResourceImpl(Resource resource, TemplateResourceResolver resolver) {
        this.resource = resource;
        this.path = this.resource.getPath();
        this.resolver = resolver;
    }

    public String getDescription() {
        return this.path.toString();
    }

    public String getBaseName() {
        return this.path.getNameWithoutExtension();
    }

    public boolean exists() {
        return true;
    }

    public Reader reader() throws IOException {
        return IOHelper.toCharSource((ByteSource)this.resource.getBytes()).openBufferedStream();
    }

    public ITemplateResource relative(String relativeLocation) {
        return this.resolver.resolve(this.path, relativeLocation);
    }
}

