/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.thymeleaf.internal;

import com.google.common.io.Files;
import io.purplejs.core.RunMode;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.thymeleaf.internal.TemplateResourceImpl;
import io.purplejs.thymeleaf.internal.TemplateResourceResolver;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;

final class TemplateResolverImpl
extends AbstractConfigurableTemplateResolver
implements TemplateResourceResolver {
    private final ResourceLoader loader;

    TemplateResolverImpl(ResourceLoader loader) {
        this.loader = loader;
    }

    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        return this.resolve(null, ownerTemplate, resourceName);
    }

    private boolean isDisableCache() {
        return RunMode.get() == RunMode.DEV;
    }

    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        if (this.isDisableCache()) {
            return new NonCacheableCacheEntryValidity();
        }
        return super.computeValidity(configuration, ownerTemplate, template, templateResolutionAttributes);
    }

    private ITemplateResource resolve(ResourcePath base, String ownerTemplate, String location) {
        ResourcePath parent = this.findParent(base, ownerTemplate);
        return this.resolve(parent, location);
    }

    private ResourcePath findParent(ResourcePath base, String ownerTempalte) {
        return ownerTempalte != null ? ResourcePath.from((String)ownerTempalte) : base;
    }

    @Override
    public ITemplateResource resolve(ResourcePath base, String location) {
        ResourcePath resolved = this.resolvePath(base, location);
        Resource resource = this.loader.loadOrNull(resolved);
        return resource != null ? new TemplateResourceImpl(resource, this) : null;
    }

    private ResourcePath resolvePath(ResourcePath base, String location) {
        if (Files.getFileExtension((String)location).equals("")) {
            return this.resolvePath(base, location + ".html");
        }
        return base != null ? base.resolve("..").resolve(location) : ResourcePath.from((String)location);
    }
}

