/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.router.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RoutePattern {
    private static final Pattern PARAM = Pattern.compile("\\{(\\w+)(:(.+))?\\}");
    private final Pattern pattern;
    private final List<String> pathParams;

    private RoutePattern(Pattern pattern, List<String> pathParams) {
        this.pattern = pattern;
        this.pathParams = pathParams;
    }

    boolean matches(String path) {
        return this.pattern.matcher(path).matches();
    }

    Map<String, String> getPathParams(String path) {
        HashMap map = Maps.newHashMap();
        Matcher matcher = this.pattern.matcher(path);
        if (!matcher.matches()) {
            return map;
        }
        for (int i = 0; i < matcher.groupCount(); ++i) {
            map.put(this.pathParams.get(i), matcher.group(i + 1));
        }
        return map;
    }

    static RoutePattern compile(String pattern) {
        String regexp = "";
        ArrayList pathParams = Lists.newArrayList();
        for (String part : Splitter.on((char)'/').omitEmptyStrings().trimResults().split((CharSequence)pattern)) {
            Matcher matcher = PARAM.matcher(part);
            if (!matcher.matches()) {
                regexp = regexp + "/" + part;
                continue;
            }
            pathParams.add(matcher.group(1));
            String partExpr = matcher.group(3);
            regexp = regexp + "/(" + (partExpr != null ? partExpr : "[^/]+") + ")";
        }
        return new RoutePattern(Pattern.compile(regexp), pathParams);
    }
}

