/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.router.internal;

import com.google.common.collect.Lists;
import io.purplejs.router.internal.Route;
import io.purplejs.router.internal.RouteMatch;
import io.purplejs.router.internal.RouteMatchImpl;
import io.purplejs.router.internal.RoutePattern;
import java.util.List;
import jdk.nashorn.api.scripting.JSObject;

public final class Router {
    private final List<Route> list = Lists.newArrayList();

    public void add(String method, String pattern, JSObject handler) {
        RoutePattern routePattern = RoutePattern.compile(pattern);
        this.list.add(new Route(method, routePattern, handler));
    }

    public RouteMatch matches(String method, String path) {
        for (Route route : this.list) {
            if (!route.matches(method, path)) continue;
            return this.newRouteMatch(route, path);
        }
        if (method.equals("HEAD")) {
            return this.matches("GET", path);
        }
        return null;
    }

    private RouteMatch newRouteMatch(Route route, String path) {
        return new RouteMatchImpl(route.getPathParams(path), route.getHandler());
    }
}

