/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.websocket;

import com.google.common.collect.Sets;
import io.purplejs.core.value.ScriptValue;
import io.purplejs.http.internal.websocket.WebSocketConfigImpl;
import io.purplejs.http.websocket.WebSocketConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class WebSocketConfigFactory {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);

    public WebSocketConfig create(ScriptValue value) {
        if (value == null) {
            return null;
        }
        WebSocketConfigImpl config = new WebSocketConfigImpl();
        config.subProtocols = this.parseSubProtocols(value.getMember("subProtocols"));
        config.attributes = value.getMember("attributes");
        config.group = this.getString(value.getMember("group"), "default");
        config.timeout = this.getLong(value.getMember("timeout"), DEFAULT_TIMEOUT);
        return config;
    }

    private Set<String> parseSubProtocols(ScriptValue value) {
        HashSet set = Sets.newHashSet();
        if (value == null) {
            return set;
        }
        if (value.isValue()) {
            set.add(value.getValue().toString());
        } else if (value.isArray()) {
            set.addAll(value.getArray().stream().filter(ScriptValue::isValue).map(item -> item.getValue().toString()).collect(Collectors.toList()));
        }
        return set;
    }

    private String getString(ScriptValue value, String defValue) {
        return value != null && value.isValue() ? value.getValue().toString() : defValue;
    }

    private Long getLong(ScriptValue value, long defValue) {
        if (value != null && value.isValue()) {
            try {
                return (Long)value.getValue(Long.class);
            }
            catch (Exception e) {
                return defValue;
            }
        }
        return defValue;
    }
}

