/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.response;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.value.ScriptValue;

final class BodySerializer {
    private static final MediaType JSON_TYPE = MediaType.create((String)"application", (String)"json");

    BodySerializer() {
    }

    ByteSource toBody(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Resource) {
            return ((Resource)value).getBytes();
        }
        if (value instanceof ByteSource) {
            return (ByteSource)value;
        }
        if (value instanceof byte[]) {
            return ByteSource.wrap((byte[])((byte[])value));
        }
        if (value instanceof ScriptValue) {
            return this.toBody((ScriptValue)value);
        }
        return this.toBody(value.toString());
    }

    private ByteSource toBody(ScriptValue value) {
        if (value.isFunction()) {
            return this.toBody(value.call(new Object[0]));
        }
        if (value.isArray()) {
            return this.toBody(value.toJson());
        }
        if (value.isObject()) {
            return this.toBody(value.toJson());
        }
        return this.toBody(value.getValue());
    }

    private ByteSource toBody(String value) {
        return ByteSource.wrap((byte[])value.getBytes(Charsets.UTF_8));
    }

    MediaType findType(ScriptValue value) {
        if (value == null) {
            return null;
        }
        if (value.isArray() || value.isObject()) {
            return JSON_TYPE;
        }
        return null;
    }
}

