/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.lib;

import com.google.common.net.MediaType;
import io.purplejs.core.json.JsonGenerator;
import io.purplejs.core.json.JsonSerializable;
import io.purplejs.http.multipart.MultipartForm;
import io.purplejs.http.multipart.MultipartItem;
import java.util.List;

final class MultipartLibHelper {
    private final MultipartForm form;

    MultipartLibHelper(MultipartForm form) {
        this.form = form != null ? form : new MultipartForm();
    }

    JsonSerializable getFormAsJson() {
        return this::serializeForm;
    }

    JsonSerializable getItemAsJson(String name, int index) {
        MultipartItem item = this.form.get(name, index);
        return item != null ? this.itemToJson(item) : null;
    }

    private JsonSerializable itemToJson(MultipartItem item) {
        return gen -> {
            gen.map();
            this.serializeItem(gen, item);
            gen.end();
        };
    }

    private void serializeForm(JsonGenerator gen) {
        gen.map();
        for (String name : this.form.getNames()) {
            List<MultipartItem> values = this.form.getAll(name);
            if (values.size() == 1) {
                gen.map(name);
                this.serializeItem(gen, values.get(0));
                gen.end();
                continue;
            }
            gen.array(name);
            values.forEach(item -> this.itemToJson((MultipartItem)item).serialize(gen));
            gen.end();
        }
        gen.end();
    }

    private void serializeItem(JsonGenerator gen, MultipartItem item) {
        gen.value("name", (Object)item.getName());
        gen.value("fileName", (Object)item.getFileName());
        gen.value("contentType", (Object)this.toString(item.getContentType()));
        gen.value("size", (Object)item.getSize());
        gen.value("stream", (Object)item.getBytes());
    }

    private String toString(MediaType type) {
        return type != null ? type.withoutParameters().toString() : null;
    }
}

