/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.lib;

import com.google.common.net.MediaType;
import io.purplejs.core.json.JsonSerializable;
import io.purplejs.http.Request;
import io.purplejs.http.internal.lib.MultipartLibHelper;
import java.util.function.Supplier;

public final class HttpLibHelper {
    private Supplier<Request> currentRequest;

    public void setRequestProvider(Supplier<Request> provider) {
        this.currentRequest = provider;
    }

    public Request getRequest() {
        return this.currentRequest.get();
    }

    public boolean isJsonBody() {
        MediaType type = this.getRequest().getContentType();
        return type != null && type.withoutParameters().is(MediaType.JSON_UTF_8.withoutParameters());
    }

    public boolean isMultipart() {
        return this.getRequest().getMultipart() != null;
    }

    private MultipartLibHelper getMultipartHelper() {
        return new MultipartLibHelper(this.getRequest().getMultipart());
    }

    public JsonSerializable getMultipartForm() {
        return this.getMultipartHelper().getFormAsJson();
    }

    public JsonSerializable getMultipartItem(String name, int index) {
        return this.getMultipartHelper().getItemAsJson(name, index);
    }
}

