/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import io.purplejs.core.value.ScriptExports;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.ResponseBuilder;
import io.purplejs.http.Status;
import io.purplejs.http.internal.handler.BaseRequestCommand;
import io.purplejs.http.internal.handler.JsonRequest;

final class ServeRequestCommand
extends BaseRequestCommand {
    private static final String GET_METHOD = "get";
    private static final String HEAD_METHOD = "head";
    private static final String SERVICE_METHOD = "service";

    ServeRequestCommand(Request request) {
        super(request);
    }

    @Override
    protected Response doExecute(ScriptExports exports) {
        String method = this.findMethod(exports);
        if (method == null) {
            return this.methodNotAllowed();
        }
        JsonRequest wrapper = new JsonRequest(this.request);
        return this.executeMethod(exports, method, wrapper);
    }

    private String findMethod(ScriptExports exports) {
        String method = this.request.getMethod().toLowerCase();
        if (exports.hasMethod(method)) {
            return method;
        }
        if (exports.hasMethod(SERVICE_METHOD)) {
            return SERVICE_METHOD;
        }
        if (method.equals(HEAD_METHOD) && exports.hasMethod(GET_METHOD)) {
            return GET_METHOD;
        }
        return null;
    }

    private Response methodNotAllowed() {
        return ResponseBuilder.newBuilder().status(Status.METHOD_NOT_ALLOWED).build();
    }
}

