/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import io.purplejs.core.value.ScriptExports;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.Status;
import io.purplejs.http.internal.handler.BaseRequestCommand;
import io.purplejs.http.internal.handler.JsonError;

final class ServeErrorCommand
extends BaseRequestCommand {
    private static final String HANDLE_PREFIX = "handle";
    private static final String GENERAL_HANDLE = "handleError";
    private final Status status;
    private final Throwable cause;

    ServeErrorCommand(Request request, Status status, Throwable cause) {
        super(request);
        this.status = status;
        this.cause = cause;
    }

    @Override
    protected Response doExecute(ScriptExports exports) {
        String method = this.findMethod(exports);
        if (method == null) {
            return null;
        }
        JsonError wrapper = new JsonError(this.status, this.cause, this.request);
        return this.executeMethod(exports, method, wrapper);
    }

    private String findMethod(ScriptExports exports) {
        String name = HANDLE_PREFIX + this.status.getCode();
        if (exports.hasMethod(name)) {
            return name;
        }
        if (exports.hasMethod(GENERAL_HANDLE)) {
            return GENERAL_HANDLE;
        }
        return null;
    }
}

