/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import io.purplejs.core.json.JsonGenerator;
import io.purplejs.core.json.JsonSerializable;
import io.purplejs.http.Request;
import io.purplejs.http.Status;
import io.purplejs.http.internal.handler.JsonRequest;

final class JsonError
implements JsonSerializable {
    private final Status status;
    private final Throwable cause;
    private final Request request;

    JsonError(Status status, Throwable cause, Request request) {
        this.status = status;
        this.cause = cause;
        this.request = request;
    }

    public void serialize(JsonGenerator gen) {
        gen.map();
        gen.value("status", (Object)this.status.getCode());
        gen.value("message", (Object)this.getMessage());
        gen.value("exception", (Object)this.cause);
        gen.value("request", (Object)new JsonRequest(this.request));
        gen.end();
    }

    private String getMessage() {
        if (this.cause != null) {
            return this.cause.getMessage();
        }
        return this.status.getReasonPhrase();
    }
}

