/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.error;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.util.Stack;

final class HtmlBuilder {
    private final Escaper escaper = HtmlEscapers.htmlEscaper();
    private final StringBuilder str = new StringBuilder();
    private final Stack<String> openTags = new Stack();
    private boolean addedInner = false;

    HtmlBuilder() {
    }

    private void closeIfNeeded() {
        if (!this.addedInner && !this.openTags.isEmpty()) {
            this.str.append('>');
        }
    }

    HtmlBuilder open(String name) {
        this.closeIfNeeded();
        this.str.append('<');
        this.str.append(name);
        this.openTags.push(name);
        this.addedInner = false;
        return this;
    }

    HtmlBuilder close() {
        this.str.append("</");
        this.str.append(this.openTags.pop());
        this.str.append('>');
        return this;
    }

    HtmlBuilder closeEmpty() {
        this.str.append("/>");
        this.openTags.pop();
        return this;
    }

    HtmlBuilder attribute(String name, String value) {
        this.str.append(' ');
        this.str.append(name);
        this.str.append("=\"");
        this.str.append(value);
        this.str.append('\"');
        this.addedInner = false;
        return this;
    }

    HtmlBuilder escapedText(String text) {
        return this.text(this.escaper.escape(text));
    }

    HtmlBuilder text(String text) {
        this.closeIfNeeded();
        this.str.append(text);
        this.addedInner = true;
        return this;
    }

    public String toString() {
        return this.str.toString();
    }
}

