/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import io.purplejs.core.json.JsonGenerator;
import io.purplejs.core.json.JsonSerializable;
import io.purplejs.http.Headers;
import io.purplejs.http.Parameters;
import io.purplejs.http.Request;
import java.util.Collection;
import java.util.Map;

final class JsonRequest
implements JsonSerializable {
    private final Request request;

    JsonRequest(Request request) {
        this.request = request;
    }

    public void serialize(JsonGenerator gen) {
        gen.map();
        gen.value("method", (Object)this.request.getMethod());
        gen.value("scheme", (Object)this.request.getUri().getScheme());
        gen.value("host", (Object)this.request.getUri().getHost());
        gen.value("port", (Object)this.request.getUri().getPort());
        gen.value("path", (Object)this.request.getUri().getPath());
        gen.value("uri", (Object)this.request.getUri());
        gen.value("contentType", (Object)this.request.getContentType());
        gen.value("contentLength", (Object)this.request.getContentLength());
        gen.value("webSocket", (Object)this.request.isWebSocket());
        gen.value("wrapped", (Object)this.request);
        this.serializeParameters(gen, this.request.getParameters());
        this.serializeHeaders(gen, this.request.getHeaders());
        this.serializeCookies(gen, this.request.getCookies());
        gen.end();
    }

    private void serializeParameters(JsonGenerator gen, Parameters params) {
        gen.map("params");
        for (Map.Entry entry : params.asMap().entrySet()) {
            Collection values = (Collection)entry.getValue();
            if (values.size() == 1) {
                gen.value((String)entry.getKey(), values.iterator().next());
                continue;
            }
            gen.array((String)entry.getKey());
            values.forEach(arg_0 -> ((JsonGenerator)gen).value(arg_0));
            gen.end();
        }
        gen.end();
    }

    private boolean shouldSerializeHeader(String name) {
        return !name.equalsIgnoreCase("Cookie");
    }

    private void serializeHeaders(JsonGenerator gen, Headers headers) {
        gen.map("headers");
        headers.entrySet().stream().filter(entry -> this.shouldSerializeHeader((String)entry.getKey())).forEach(entry -> gen.value((String)entry.getKey(), entry.getValue()));
        gen.end();
    }

    private void serializeCookies(JsonGenerator gen, Map<String, String> cookies) {
        gen.map("cookies");
        cookies.forEach((arg_0, arg_1) -> ((JsonGenerator)gen).value(arg_0, arg_1));
        gen.end();
    }
}

