/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import com.google.common.io.ByteSource;
import io.purplejs.core.Engine;
import io.purplejs.core.exception.ProblemException;
import io.purplejs.core.resource.ResourcePath;
import io.purplejs.core.value.ScriptExports;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.Status;
import io.purplejs.http.handler.HttpHandler;
import io.purplejs.http.internal.error.ErrorRenderer;
import io.purplejs.http.internal.handler.HandleEventCommand;
import io.purplejs.http.internal.handler.ServeErrorCommand;
import io.purplejs.http.internal.handler.ServeRequestCommand;
import io.purplejs.http.internal.websocket.WebSocketRegistry;
import io.purplejs.http.websocket.WebSocketEvent;
import io.purplejs.http.websocket.WebSocketEventType;
import io.purplejs.http.websocket.WebSocketSession;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpHandlerImpl
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHandlerImpl.class);
    Engine engine;
    ResourcePath resource;
    ErrorRenderer errorRenderer;
    WebSocketRegistry webSocketRegistry;

    HttpHandlerImpl() {
    }

    @Override
    public Response serve(Request request) {
        ServeRequestCommand command = new ServeRequestCommand(request);
        return this.execute(command);
    }

    private <R> R execute(Function<ScriptExports, R> command) {
        ScriptExports exports = this.engine.require(this.resource);
        return command.apply(exports);
    }

    @Override
    public Response errorIfNeeded(Request request, Response response) {
        boolean isError;
        if (request.isWebSocket()) {
            return response;
        }
        Status status = response.getStatus();
        boolean bl = isError = status.isServerError() || status.isClientError();
        if (!isError) {
            return response;
        }
        ByteSource body = response.getBody();
        if (body != null) {
            return response;
        }
        return this.handleError(request, status, null);
    }

    @Override
    public Response handleException(Request request, Throwable cause) {
        LOG.error("Request [" + request.getUri() + "] caused an exception", cause);
        if (request.isWebSocket()) {
            return null;
        }
        return this.handleError(request, Status.INTERNAL_SERVER_ERROR, cause);
    }

    private Response handleError(Request request, Status status, Throwable cause) {
        Response result = this.handleErrorInJs(request, status, cause);
        if (result != null) {
            return result;
        }
        return this.errorRenderer.handle(request, status, cause);
    }

    private Response handleErrorInJs(Request request, Status status, Throwable cause) {
        if (!this.canHandleErrorInJs(cause)) {
            return null;
        }
        ServeErrorCommand command = new ServeErrorCommand(request, status, cause);
        return this.execute(command);
    }

    private boolean canHandleErrorInJs(Throwable cause) {
        return !(cause instanceof ProblemException);
    }

    @Override
    public boolean handleEvent(WebSocketEvent event) {
        WebSocketSession session = event.getSession();
        WebSocketEventType type = event.getType();
        if (type == WebSocketEventType.OPEN) {
            this.webSocketRegistry.add(session);
        } else if (type == WebSocketEventType.CLOSE) {
            this.webSocketRegistry.remove(session);
        }
        HandleEventCommand command = new HandleEventCommand(event);
        return this.execute(command);
    }
}

