/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.error;

import com.google.common.base.Charsets;
import io.purplejs.core.exception.ProblemException;
import io.purplejs.core.resource.Resource;
import io.purplejs.core.resource.ResourceLoader;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.Status;
import io.purplejs.http.error.ErrorHandler;
import io.purplejs.http.error.ErrorInfo;
import io.purplejs.http.internal.error.DefaultErrorHandler;
import io.purplejs.http.internal.error.ErrorInfoImpl;
import io.purplejs.http.internal.error.ErrorRenderer;
import java.util.Collections;
import java.util.List;

public final class ErrorRendererImpl
implements ErrorRenderer {
    private final ErrorHandler handler;
    private final ResourceLoader resourceLoader;

    public ErrorRendererImpl(ErrorHandler handler, ResourceLoader resourceLoader) {
        this.handler = handler != null ? handler : new DefaultErrorHandler();
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Response handle(Request request, Status status, Throwable ex) {
        ErrorInfo info = this.toInfo(request, status, ex);
        return this.handler.handle(info);
    }

    private ErrorInfo toInfo(Request request, Status status, Throwable ex) {
        ErrorInfoImpl info = new ErrorInfoImpl();
        info.cause = ex;
        info.request = request;
        info.status = status;
        if (ex instanceof ProblemException) {
            this.populate(info, (ProblemException)ex);
        }
        return info;
    }

    private void populate(ErrorInfoImpl info, ProblemException ex) {
        info.path = ex.getPath();
        Resource resource = this.resourceLoader.loadOrNull(info.path);
        info.lines = this.loadLines(resource);
    }

    private List<String> loadLines(Resource resource) {
        if (resource == null) {
            return Collections.emptyList();
        }
        try {
            return resource.getBytes().asCharSource(Charsets.UTF_8).readLines();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

