/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.lib;

import com.google.common.io.ByteSource;
import io.purplejs.http.websocket.WebSocketManager;
import io.purplejs.http.websocket.WebSocketSession;

public final class WebSocketLibHelper {
    private WebSocketManager manager;

    public void setManager(WebSocketManager manager) {
        this.manager = manager;
    }

    public void sendMessage(String id, Object message) {
        this.sendMessage(this.manager.getSession(id), message);
    }

    public void sendMessageToGroup(String group, Object message, String excludeId) {
        this.manager.getByGroup(group).filter(session -> excludeId == null || !session.getId().equals(excludeId)).forEach(session -> this.sendMessage((WebSocketSession)session, message));
    }

    private void sendMessage(WebSocketSession session, Object message) {
        if (session == null) {
            return;
        }
        if (message == null) {
            return;
        }
        if (message instanceof ByteSource) {
            session.send((ByteSource)message);
        } else {
            session.send(message.toString());
        }
    }
}

