/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.handler;

import io.purplejs.core.json.JsonGenerator;
import io.purplejs.core.json.JsonSerializable;
import io.purplejs.http.websocket.WebSocketEvent;
import io.purplejs.http.websocket.WebSocketSession;

final class JsonWebSocketEvent
implements JsonSerializable {
    private final WebSocketEvent event;

    JsonWebSocketEvent(WebSocketEvent event) {
        this.event = event;
    }

    public void serialize(JsonGenerator gen) {
        gen.map();
        gen.value("type", (Object)this.event.getType().name().toLowerCase());
        gen.value("message", (Object)this.event.getMessage());
        gen.value("binary", (Object)this.event.getBinary());
        gen.value("closeCode", (Object)this.event.getCloseCode());
        gen.value("closeReason", (Object)this.event.getCloseReason());
        this.serializeError(gen, this.event.getError());
        this.serializeSession(gen);
        gen.end();
    }

    private void serializeError(JsonGenerator gen, Throwable error) {
        gen.value("error", (Object)(error != null ? error.getMessage() : null));
    }

    private void serializeSession(JsonGenerator gen) {
        WebSocketSession session = this.event.getSession();
        gen.map("session");
        gen.value("id", (Object)session.getId());
        gen.value("group", (Object)session.getGroup());
        gen.value("subProtocol", (Object)session.getSubProtocol());
        gen.value("attributes", (Object)session.getAttributes());
        gen.value("wrapped", (Object)session);
        gen.end();
    }
}

