/*
 * Decompiled with CFR 0.152.
 */
package io.purplejs.http.internal.error;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import com.google.gson.JsonObject;
import io.purplejs.core.exception.ProblemException;
import io.purplejs.http.Request;
import io.purplejs.http.Response;
import io.purplejs.http.ResponseBuilder;
import io.purplejs.http.error.ErrorHandler;
import io.purplejs.http.error.ErrorInfo;
import io.purplejs.http.internal.error.ErrorPageBuilder;
import java.util.List;

public final class DefaultErrorHandler
implements ErrorHandler {
    @Override
    public Response handle(ErrorInfo ex) {
        MediaType type = this.findRenderType(ex.getRequest());
        ResponseBuilder builder = ResponseBuilder.newBuilder();
        builder.status(ex.getStatus());
        builder.contentType(type);
        String body = this.renderBody(ex, type);
        builder.body(ByteSource.wrap((byte[])body.getBytes(Charsets.UTF_8)));
        return builder.build();
    }

    private String renderBody(ErrorInfo ex, MediaType type) {
        if (this.isHtmlType(type)) {
            return this.renderHtml(ex);
        }
        return this.renderJson(ex);
    }

    private String renderHtml(ErrorInfo ex) {
        ErrorPageBuilder builder = new ErrorPageBuilder();
        builder.cause(ex.getCause());
        builder.status(ex.getStatus().getCode());
        builder.title(ex.getStatus().getReasonPhrase());
        builder.description(this.getDescription(ex.getCause()));
        builder.lines(ex.getLines());
        builder.problem(this.findProblemException(ex.getCause()));
        return builder.build();
    }

    private String renderJson(ErrorInfo ex) {
        JsonObject json = new JsonObject();
        json.addProperty("status", (Number)ex.getStatus().getCode());
        json.addProperty("message", ex.getStatus().getReasonPhrase());
        json.addProperty("description", this.getDescription(ex.getCause()));
        return json.toString();
    }

    private MediaType findRenderType(Request request) {
        return this.findRenderType(request.getHeaders().getAccept());
    }

    private MediaType findRenderType(List<MediaType> accept) {
        for (MediaType type : accept) {
            if (this.isHtmlType(type)) {
                return MediaType.HTML_UTF_8;
            }
            if (!this.isJsonType(type)) continue;
            return MediaType.JSON_UTF_8;
        }
        return MediaType.JSON_UTF_8;
    }

    private boolean isHtmlType(MediaType type) {
        return type.subtype().equalsIgnoreCase("html");
    }

    private boolean isJsonType(MediaType type) {
        return type.subtype().equalsIgnoreCase("json");
    }

    private String getDescription(Throwable cause) {
        if (cause == null || cause.getMessage() == null) {
            return "No description";
        }
        return cause.getMessage();
    }

    private ProblemException findProblemException(Throwable cause) {
        if (cause == null) {
            return null;
        }
        if (cause instanceof ProblemException) {
            return (ProblemException)cause;
        }
        return this.findProblemException(cause.getCause());
    }
}

